<?php

namespace Modules\Policy\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Policy\Database\factories\CookiesFactory;

class Cookies extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'code', 'sequence', 'default', 'status', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "cookies";
    protected $primaryKey = "id";

    protected static function newFactory(): CookiesFactory
    {
        return CookiesFactory::new();
    }
    protected static function boot(): void
    {
        parent::boot();
        static::deleting(function ($model) {
            $model->langs()->delete();
        });
    }

    public function langs()
    {
        return $this->hasMany(CookiesTranslate::class, 'cookie_id', 'id');
    }
    public function local()
    {
        return $this->hasOne(CookiesTranslate::class, 'cookie_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
}
