<?php

namespace Modules\Policy\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Mwz\app\Http\Controllers\SlugController;
use Modules\Policy\app\Models\AcceptsLog;
use Modules\Policy\app\Models\Cookies;
use Modules\Policy\app\Models\Marketing;
use Modules\Policy\app\Models\Policy;
use Modules\Policy\app\Models\Term;

class PolicyController extends AdminController
{
	public static function policy()
	{
		$config = config("policy.policy");
		$data = [];
		$req = Policy::orderBy('created_at', 'desc')->first();
		if (!empty($req)) {
			$data['id'] = $req->id;
			foreach ($config['input'] as $key => $item) {
				if (!empty($item['status']) && !in_array($key, ['title', 'text', 'body']))
					$data[$key] = mwz_getTextString($req->local->{$key} ?? '', $item['type'] == 'texteditor');
			}

			if (!empty($config['seo']))
				$data['url'] = SlugController::getRoute('index','pdpa', 1) ?? '';
		}

		return $data;
	}

	/**
	 * Function : pdpa_detail
	 * Dev : Wan
	 * Update Date : 12 October 2021
	 * @param Get
	 * @return json of pdpa
	 */
	public static function get_policy()
	{
		$data = Policy::orderBy('created_at', 'desc')->first();
		$result = [];
		if (!empty($data)) {
			$result['id'] = $data->id;
			$result['name'] = mwz_getTextString($data->local->name ?? "");
			$result['desc'] = mwz_getTextString($data->local->desc ?? "");
			$result['detail'] = mwz_getTextString($data->local->detail ?? "");
			$result['url'] = SlugController::getRoute("policy", "policy", 1);
		}
		return $result;
	}

	public static function term()
	{
		$config = config("policy.term");
		$data = [];
		$req = Term::orderBy('created_at', 'desc')->first();
		if (!empty($req)) {
			foreach ($config['input'] as $key => $item) {
				if (!empty($item['status']))
					$data[$key] = mwz_getTextString($req->local->{$key} ?? '', $item['type'] == 'texteditor');
			}

			if (!empty($config['seo']))
				$data['url'] = SlugController::getRoute('policy', 'term');
		}

		return $data;
	}

	public static function marketing()
	{
		$config = config("policy.marketing");
		$data = [];
		$req = Marketing::orderBy('created_at', 'desc')->first();
		if (!empty($req)) {
			foreach ($config['input'] as $key => $item) {
				if (!empty($item['status'])) {
					$data[$key] = mwz_getTextString($req->local->{$key} ?? '', $item['type'] == 'texteditor');
				}
			}
			if (!empty($config['seo'])) {
				$data['url'] = SlugController::getRoute('policy', 'marketing');
			}
		}
		return $data;
	}

	public static function cookies()
	{
		$config = config("policy.policy");

		$data = [];
		$req = Policy::orderBy('created_at', 'desc')->first();
		if (!empty($req)) {
			foreach ($config['input'] as $key => $item) {
				if (!empty($item['status']) && in_array($key, ['title', 'text', 'body'])) {
					$data[$key] = mwz_getTextString($req->local->{$key} ?? '', $item['type'] == 'texteditor');
				}
			}
		}
		$data['list'] = self::cookies_list();
		return $data;
	}

	private static function cookies_list()
	{
		$accept = Cookie::has('cookies_accept') ? json_decode(Cookie::get('cookies_accept'), true) : null;
		$data = [];
		$config = config("policy.cookies");
		$reqs = Cookies::where('status', 1)->get();
		if (!empty($reqs)) {
			foreach ($reqs as $req) {
				$code = $req->code;
				$list = [
					'default' => $req->default ?? 0,
					'checked' => $accept[$req->code] ?? $req->default
				];
				foreach ($config['input'] as $key => $item) {
					if (!empty($item['status'])) {
						$list[$key] = mwz_getTextString($req->local->{$key} ?? '', $item['type'] == 'texteditor');
					}
				}
				if (!empty($config['seo'])) {
					$list['url'] = SlugController::getRoute('policy', 'cookies', $req->id);
				}
				$data[$code] = $list;
			}
		}
		return $data;
	}

	public static function detail()
	{
		$data = [];
		$config = config("policy.cookies");
		$reqs = Cookies::where('status', 1)->get();
		if (!empty($reqs)) {
			foreach ($reqs as $req) {
				$list = null;
				foreach ($config['input'] as $key => $item) {
					if (!empty($item['status'])) {
						$list[$key] = mwz_getTextString($req->local->{$key} ?? '', $item['type'] == 'texteditor');
					}
				}
				$data[$req->id] = $list;
			}
		}
		return $data;
	}

	public function save(Request $request)
	{
		if ($request->ajax()) {
			$status = $request->get('status');

			if ($status > 0) {
				AcceptsLog::updateorcreate([
					"ip" => ip_address(),
					"agent" => $request->server('HTTP_USER_AGENT'),
				], [
					"policy_id" => $status,
					"status" => $status > 0,
					"updated_at" => now(),
				]);

				Cookie::queue(Cookie::make('pdpa', $status));
				$request->cookie('pdpa');
			}

			return self::response(['msg' => 'Success']);
		}

		return self::response(['msg' => 'Error'], Response::HTTP_BAD_REQUEST);
	}
}
