<?php

namespace Modules\Policy\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Policy\app\Models\AcceptsLog;
use Modules\Policy\app\Models\CookiesLog;

class CookiesController extends AdminController
{
	public function accept(Request $request)
	{
		self::cookies_accept($request);
		self::policy_accept();
		return self::response(['msg' => __('noti.success')]);
	}

	private static function cookies_accept(Request $request)
	{
		$attr = [
			'ad_storage' => $request->get('ad_storage') ?? 0,
			'ad_user_data' => $request->get('ad_user_data') ?? 0,
			'ad_personalization' => $request->get('ad_personalization') ?? 0,
			'analytics_storage' => $request->get('analytics_storage') ?? 0
		];

		$cookies = CookiesLog::updateOrCreate([
			"ip" => ip_address(),
			"agent" => $_SERVER['HTTP_USER_AGENT'] ?? null,
			"member_id" => auth('member')->user()->id ?? 0
		], $attr);

		Cookie::queue(Cookie::make(
			'cookies_accept',
			json_encode([
				'ad_storage' => !empty($cookies->ad_storage) ? 'granted' : 'denied',
				'ad_user_data' => !empty($cookies->ad_user_data) ? 'granted' : 'denied',
				'ad_personalization' => !empty($cookies->ad_personalization) ? 'granted' : 'denied',
				'analytics_storage' => !empty($cookies->analytics_storage) ? 'granted' : 'denied'
			]),
			365 * 24 * 60
		));
	}
	private static function policy_accept()
	{
		AcceptsLog::updateOrCreate([
			"ip" => ip_address(),
			"agent" => $_SERVER['HTTP_USER_AGENT'] ?? null,
		], [
			"member_id" => auth('member')->user()->id ?? 0,
			"status" => 1
		]);
	}
}
