<?php

namespace Modules\Policy\app\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Policy\app\Models\AcceptsLog;

class AcceptAdminController extends AdminController
{
	/**
	 * Function : construct
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function __construct()
	{
		$this->middleware('auth:admin');
		self::$navbar =  [
			['name' => __("policy::accept.title"), 'url' => null],
			['name' => __("policy::accept.name"), 'url' => route_has("admin.policy.logs.index")]
		];
	}
	public function index()
	{
		return view('policy::accept.index', ['navbar' => self::$navbar]);
	}

	/**
	 * Function : pdpa_detail datatable ajax response
	 * Dev : jang
	 * Update Date : 12 October 2021
	 * @param Get
	 * @return json of pdpa
	 */
	public function datatable_ajax(Request $request)
	{
		if ($request->ajax()) {
			$dt_column = array('id', 'ip', 'agent', 'status', 'created_at');
			$dt_order = $request->get('order')[0]['column'];
			$dt_dir = $request->get('order')[0]['dir'];
			$dt_start = $request->get('start');
			$dt_length = $request->get('length');
			$dt_search = $request->get('search')['value'];

			// create pdpa_detail object
			$req = new AcceptsLog();

			// add search query if have search from datable
			if (!empty($dt_search)) {
				$req = $req->Where(function ($query) use ($dt_search) {
					$query->orwhere('ip', 'like', "%" . $dt_search . "%")
						->orwhere('agent', 'like', "%" . $dt_search . "%")
						->orwhere('status', 'like', "%" . $dt_search . "%")
						->orwhere('created_at', 'like', "%" . $dt_search . "%");
				});
			}

			// set query order & limit from datatable
			$dt_total = $req->count();

			$data = $req->orderBy($dt_column[$dt_order], $dt_dir)
				->offset($dt_start)
				->limit($dt_length)->get();

			// prepare datatable for response
			$tables = datatables($data)
				->addIndexColumn()
				->setRowId('id')
				->setRowClass('pdpa_row')
				->setTotalRecords($dt_total)
				->setFilteredRecords($dt_total)
				->setOffset($dt_start)
				->editColumn('agent', function ($record) {
					return limit($record->agent ?? '', 50);
				})->editColumn('status', function ($record) {
					return ($record->status == 1 ? "Accepted" : 'Denied');
				})->editColumn('created_at', function ($record) {
					return str_replace(' ', '<br>', date("Y-m-d H:i:s", strtotime($record->updated_at)));
				})->escapeColumns([]);

			// response datatable json
			return $tables->make(true);
		}
	}
}
