<?php

use Illuminate\Support\Facades\Route;
use Modules\OilPrice\app\Http\Controllers\OilPriceAdminController;
use Modules\OilPrice\app\Http\Controllers\OilPriceController;
use Modules\OilPrice\app\Http\Controllers\OilPricePermisstionController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth:admin', 'adminAccessControl'])->prefix('admin')->name('admin.')->group(function () {
	// ['method', 'url', 'controller', 'name']
	$default_route_oilprice = [
		['get', '/', 'index', 'index'],
		['get', '/datatable_ajax', 'datatable_ajax', 'datatable_ajax'],
		['get', '/add', 'form', 'add'],
		['get', '/edit/{id?}', 'form', 'edit'],
		['get', '/view/{id?}', 'form', 'view'],
		['post', '/save', 'save', 'save'],
		['post', '/set-sort', 'set_sort', 'set_sort'],
		['post', '/set-default', 'set_default', 'set_default'],
		['post', '/set-status', 'set_status', 'set_status'],
		['post', '/set-delete', 'set_delete', 'set_delete'],
		['post', '/get-list', 'get_list', 'get_list'],
		['post', '/get-scheme-type-list', 'get_scheme_type_list', 'get_scheme_type_list'],
		['get', '/export', 'export', 'export'],
		['post', '/import', 'import', 'import'],
		['get', '/download-template', 'download_template', 'download_template'],
	];
	$default_route_lavel = [
		['get', '/', 'index', 'index'],
		['get', '/datatable_ajax', 'datatable_ajax', 'datatable_ajax'],
		['get', '/add', 'form', 'add'],
		['get', '/edit/{id?}', 'form', 'edit'],
		['get', '/view/{id?}', 'form', 'view'],
		['post', '/save', 'save', 'save'],
		['post', '/set-sort', 'set_sort', 'set_sort'],
		['post', '/set-default', 'set_default', 'set_default'],
		['post', '/set-status', 'set_status', 'set_status'],
		['post', '/set-delete', 'set_delete', 'set_delete'],
		['post', '/get-list', 'get_list', 'get_list'],
		['post', '/get-scheme-type-list', 'get_scheme_type_list', 'get_scheme_type_list'],
		['get', '/download-template', 'download_template', 'download_template'],
	];

	$default_route_manage = [
		['get', '/', 'index', 'index'],
		['get', '/datatable_ajax', 'datatable_ajax', 'datatable_ajax'],
		['get', '/add', 'form', 'add'],
		['get', '/edit/{id}', 'form', 'edit'],
		['get', '/view/{id}', 'form', 'view'],
		['post', '/save', 'save', 'save'],
		['post', '/set-sort', 'set_sort', 'set_sort'],
		['post', '/set-default', 'set_default', 'set_default'],
		['post', '/set-status', 'set_status', 'set_status'],
		['post', '/set-delete', 'set_delete', 'set_delete'],
		['post', '/get-list', 'get_list', 'get_list'],
	];
	Route::prefix('oilprice')->name('oilprice.')->group(function () use ($default_route_oilprice,$default_route_lavel,$default_route_manage) {
		// Shared route for getting scheme type list
		Route::post('/oilprice/get-scheme-type-list', [OilPriceAdminController::class, 'get_scheme_type_list'])->name('oilprice.get_scheme_type_list');
		
		Route::prefix('manager')->name('manager.')->group(function () use ($default_route_lavel) {
			foreach ($default_route_lavel as $route)
				Route::{$route[0]}($route[1], [OilPriceAdminController::class, $route[2]])->name($route[3]);
		});
        Route::prefix('sale')->name('sale.')->group(function () use ($default_route_oilprice) {
			foreach ($default_route_oilprice as $route)
				Route::{$route[0]}($route[1], [OilPriceAdminController::class, $route[2]])->name($route[3]);
		});
        Route::prefix('oil')->name('oil.')->group(function () use ($default_route_oilprice) {
			foreach ($default_route_oilprice as $route)
				Route::{$route[0]}($route[1], [OilPriceAdminController::class, $route[2]])->name($route[3]);
		});

		Route::prefix('permission')->name('permission.')->group(function () use ($default_route_oilprice) {
			foreach ($default_route_oilprice as $route)
				Route::{$route[0]}($route[1], [OilPricePermisstionController::class, $route[2]])->name($route[3]);
		});
	});
});

Route::middleware(['apiLocale'])->prefix('api/v1')->name('api.')->group(function () {
	Route::prefix('oilprice')->name('oilprice.')->group(function () {
		Route::post('/click', [OilPriceController::class, 'click'])->name('click');
	});
});