<div class="card card-body">
    <div class="alert alert-warning bg-warning text-white border-0" role="alert">
        <i class="fe-bar-chart me-1"></i>
        <strong>ข้อมูล Scheme</strong> - กรอกค่า ช่วง และอัตรา (ตามประเภทโครงการที่เลือก)
    </div>
    @php
        $inputs = $config['form']['navbar']['scheme']['input'];
    @endphp
    <div class="row">
        @foreach ($inputs as $k => $v)
            @if (!empty($v['status']))
                <div class="col-md-6 mb-3">
                    @if ($v['type'] == 'number')
                        <label
                            class="form-label {{ !empty($v['validate']) ? 'required' : '' }}">{{ $v['label'] ?? __("field.{$k}") }}</label>
                        @if (!empty($v['description']))
                        @endif
                        <input type="number" class="form-control" id="{{ $k }}" name="{{ $k }}"
                            value="{{ $data->{$k} ?? '' }}"
                            placeholder="{{ $v['placeholder'] ?? __("field.{$k}_placeholder") }}"
                            step="{{ $v['step'] ?? '0.01' }}" {{ !empty($v['validate']) ? 'required' : '' }}
                            {{ (!in_array($k, $oilprice_abc_checked) and auth()->user()->id != 1) ? 'disabled' : '' }}>
                    @elseif ($v['type'] == 'selection')
                        @php
                            $selected = $data->{$k . '_name'} ?? null;
                            $chk_req = !empty($v['validate']);
                        @endphp
                        <x-select2.select id="{{ $k }}" name="{{ $k }}" label='{{ __("field.{$k}") }}' :required=$chk_req :selected=$selected url="{{ route($v['url']) }}" placeholder='{{ __("field.{$k}_placeholder") }}' parent="id" :disabled=true />
                    @else
                        <label
                            class="form-label {{ !empty($v['validate']) ? 'required' : '' }}">{{ $v['label'] ?? __("field.{$k}") }}</label>
                        <input type="text" class="form-control" id="{{ $k }}" name="{{ $k }}" value="{{ $data->{$k} ?? '' }}" placeholder="{{ $v['placeholder'] ?? __("field.{$k}_placeholder") }}" {{ !empty($v['validate']) ? 'required' : '' }} >
                    @endif
                </div>
            @endif
        @endforeach
    </div>

    <div>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Gap Range</th>
                    <th>Reference</th>
                    <th>A - อัตราสิ้นเปลือง</th>
                    <th>B - ค่าเสื่อมรถตามจริง</th>
                    <th>C - แรงกระตุ้นให้เกิดการใช้รถ</th>
                    <th>Rate</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($gap_range as $k => $v)
                    <?php
                    $a = round($v['reference'] / ($data->value_a ?? 1), 2, PHP_ROUND_HALF_UP);
                    $b = $data->value_b ?? 0;
                    $c = $data->value_c ?? 0;
                    $rate = $a + $b + $c;
                    $rate = number_format($rate, 2);
                    ?>
                    @if ($v['default'] == 1)
                        <input type="hidden" class="js-rate-input" data-index="{{ $k }}" name="rate"
                            value="{{ $rate ?? 0.0 }}">
                    @endif
                    <tr class="js-rate-row {{ $v['default'] == 1 ? 'tb_active' : '' }}"
                        data-index="{{ $k }}" data-default="{{ $v['default'] }}">
                        <td>{{ $v['gap_range'] }}</td>
                        <td class="js-reference-cell" data-reference="{{ $v['reference'] }}">
                            {{ number_format($v['reference'], 2) }}</td>
                        <td class="a_{{ $k }}">
                            {{ bcdiv($v['reference'], $data->value_a ?? 1, 2) }}
                        </td>
                        <td class="b_{{ $k }}">
                            {{ number_format($b, 2) }}
                        </td>
                        <td class="c_{{ $k }}">
                            {{ number_format($c, 2) }}
                        </td>
                        <td class="rate_{{ $k }}">
                            {{ $rate }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
