<div class="card card-body">
    <div class="alert alert-info bg-info text-white border-0" role="alert">
        <i class="fe-info me-1"></i>
        <strong>ข้อมูลพื้นฐาน</strong> - กรอกข้อมูลช่วงและราคานํ้ามัน
    </div>

    @php
        $inputs = $config['form']['navbar']['basic']['input'];
    @endphp

    @foreach ($inputs as $k => $v)
        @if (!empty($v['status']))
            <div class="mb-3">
                @if ($v['type'] == 'selection')
                    @php
                        $chk_option = !empty($data->{$k}) ? $data->{$k} : null;
                    @endphp
                    <label class="form-label {{ !empty($v['validate']) ? 'required' : '' }}">{{ $v['label'] ?? __("field.{$k}") }}</label>
                    <select class="form-select" id="{{ $k }}" name="{{ $k }}" {{ !empty($v['validate']) ? 'required' : '' }}>
                        <option value="">{{ $v['placeholder'] ?? __("field.{$k}_placeholder") }}</option>
                        @if (!empty($v['options']))
                            @foreach ($v['options'] as $k_o => $o)
                                <option value="{{ $k_o }}" @if ($chk_option == $k_o) selected @endif>
                                    {{ $o }}
                                </option>
                            @endforeach
                        @endif
                    </select>
                @elseif ($v['type'] == 'number')
                    <label class="form-label {{ !empty($v['validate']) ? 'required' : '' }}">{{ $v['label'] ?? __("field.{$k}") }}</label>
                    <input type="number" class="form-control {{ !empty($v['disabled']) ? 'disabled' : '' }}" id="{{ $k }}" name="{{ $k }}" 
                           value="{{ $data->{$k} ?? '' }}" 
                           placeholder="{{ $v['placeholder'] ?? __("field.{$k}_placeholder") }}"
                           step="{{ $v['step'] ?? '0.01' }}"
                           {{ !empty($v['validate']) ? 'required' : '' }}
                           {{ !empty($v['disabled']) ? 'disabled' : '' }}>
                    @if (!empty($v['disabled']))
                        <input type="hidden" name="{{ $k }}" value="{{ $data->{$k} ?? '' }}">
                    @endif
                @else
                    <label class="form-label {{ !empty($v['validate']) ? 'required' : '' }}">{{ $v['label'] ?? __("field.{$k}") }}</label>
                    <input type="text" class="form-control" id="{{ $k }}" name="{{ $k }}" 
                           value="{{ $data->{$k} ?? '' }}" 
                           placeholder="{{ $v['placeholder'] ?? __("field.{$k}_placeholder") }}"
                           {{ !empty($v['validate']) ? 'required' : '' }}>
                @endif
            </div>
        @endif
    @endforeach
</div>

