<?php

return [
	'oilprice' => [
		'manager' => [
			'table' => [
				'header' => [
					['title' => 'ประเภทโครงการ', 'column' => 'scheme_type', 'orderable' => true, 'class' => 'text-center', 'status' => true],
					['title' => 'A', 'column' => 'value_a', 'orderable' => true, 'class' => '', 'status' => true],
					['title' => 'B', 'column' => 'value_b', 'orderable' => true, 'class' => 'text-end', 'status' => true],
					['title' => 'C', 'column' => 'value_c', 'orderable' => true, 'class' => 'text-end', 'status' => true],
					['title' => 'อัตรา (Rate)', 'column' => 'rate', 'orderable' => true, 'class' => 'text-end', 'status' => true],
				],
				'filter' => [
					'scheme_type' => ['type' => 'select', 'url' => 'admin.oilprice.manager.get_list', 'status' => false],
				],
				'btn' => [
					'add' => false,
					'sort' => false,
					'default' => false,
					'status' => false,
					'edit' => true,
					'delete' => false,
					'export' => false,
				],
			],
			'form' => [
				'navbar' => [
					'basic' => [
						'status' => false,
						'input' => [
							'scheme_type' => ['type' => 'selection', 'status' => true, 'validate' => true, 'label' => 'ประเภทโครงการ', 'placeholder' => 'เลือกประเภทโครงการ', 'options' => ['manager' => 'Manager', 'sale' => 'Sale']],
							'gap_range' => ['type' => 'input', 'status' => true, 'validate' => true, 'label' => 'ช่วงอายุงาน (Gap)', 'placeholder' => 'เช่น 10-14.99'],
							'gap_min' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'ขั้นต่ำ', 'placeholder' => 'เช่น 10.00', 'step' => '0.01'],
							'gap_max' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'สูงสุด', 'placeholder' => 'เช่น 14.99', 'step' => '0.01'],
							'reference' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'รถอ้างอิง', 'placeholder' => 'เช่น 12.50', 'step' => '0.01'],
						],
					],
					'scheme' => [
						'status' => true,
						'input' => [
							'scheme_type' => ['type' => 'selection', 'url' => 'admin.oilprice.manager.get_list', 'status' => true,'validate' => true, 'label' => 'ประเภทโครงการ1', 'placeholder' => 'เลือกประเภทโครงการ'],
							'range_min' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'ช่วงขั้นต่ำ', 'placeholder' => 'เช่น 0.83', 'step' => '0.01'],
							'range_max' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'ช่วงสูงสุด', 'placeholder' => 'เช่น 1.25', 'step' => '0.01'],
							'value_a' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'A - อัตราสิ้นเปลือง', 'placeholder' => 'เช่น 1.04', 'step' => '0.01', 'description' => 'อัตราการสิ้นเปลืองเชื้อเพลิงต่อกิโลเมตร'],
							'value_b' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'B - ค่าเสื่อมรถตามจริง', 'placeholder' => 'เช่น 1.20', 'step' => '0.01', 'description' => 'ค่าเสื่อมราคาของรถยนต์ตามการใช้งานจริง'],
							'value_c' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'C - แรงกระตุ้นให้เกิดการใช้รถ', 'placeholder' => 'เช่น 2.00', 'step' => '0.01', 'description' => 'แรงจูงใจหรือแรงกระตุ้นให้เกิดการใช้รถยนต์'],
							'rate' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'อัตรา (Rate)', 'placeholder' => 'เช่น 4.24', 'step' => '0.01'],
						],
					],
					'summary' => [
						'status' => false,
						'input' => [
							'km_l' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'A (Km/L)', 'placeholder' => 'Manager: 12.00, Sale: 16.78', 'step' => '0.01'],
							'multiplier' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'B (ตัวคูณ)', 'placeholder' => '1.20', 'step' => '0.01'],
							'rate_per_km' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'C (THB/Km)', 'placeholder' => 'Manager: 2.00, Sale: 3.00', 'step' => '0.01'],
							'credit' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'เชื่อ (Credit)', 'placeholder' => 'เช่น 2.25', 'step' => '0.01'],
						],
					],
					'rates' => [
						'status' => false,
						'input' => [
							'gap_value' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'ค่า GAP', 'placeholder' => 'เช่น 0.70', 'step' => '0.01'],
							'currency' => ['type' => 'input', 'status' => true, 'validate' => false, 'label' => 'หน่วยเงิน', 'placeholder' => 'THB/Km'],
						],
					],
					'other' => [
						'status' => false,
						'input' => [
							'remark' => ['type' => 'textarea', 'status' => true, 'validate' => false, 'label' => 'หมายเหตุ', 'placeholder' => 'หมายเหตุเพิ่มเติม (ถ้ามี)', 'rows' => 3],
						],
					],
				],
				'sidebar' => [
					'setting' => [
						'status' => false,
						'input' => [
							'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
						],
					]
				],
			],

			'setting' => [
				'limit' => [
					'status' => false,
					'max' => 1,
				],
				'limit_default' => [
					'status' => false,
					'max' => 1,
				],
			],
		],
		'sale' => [
			'table' => [
				'header' => [
					['title' => 'Gap ราคาน้ำมัน', 'column' => 'gap_range', 'orderable' => true, 'class' => '', 'status' => true],
					['title' => 'ประเภทโครงการ', 'column' => 'scheme_type', 'orderable' => true, 'class' => 'text-center', 'status' => true],
					['title' => 'รถอ้างอิง', 'column' => 'reference', 'orderable' => true, 'class' => 'text-end', 'status' => true],
					['title' => 'อัตรา (Rate)', 'column' => 'rate', 'orderable' => true, 'class' => 'text-end', 'status' => true],
				],
				'filter' => [
					'scheme_type' => ['type' => 'select', 'url' => 'admin.oilprice.oilprice.get_scheme_type_list', 'status' => false],
				],
				'btn' => [
					'add' => true,
					'sort' => false,
					'default' => false,
					'status' => true,
					'edit' => true,
					'delete' => true,
					'export' => true,
				],
			],
			'form' => [
				'navbar' => [
					'basic' => [
						'status' => false,
						'input' => [
							'scheme_type' => ['type' => 'selection', 'status' => true, 'validate' => true, 'label' => 'ประเภทโครงการ', 'placeholder' => 'เลือกประเภทโครงการ', 'options' => ['manager' => 'Manager', 'sale' => 'Sale']],
							'gap_range' => ['type' => 'input', 'status' => true, 'validate' => true, 'label' => 'ช่วงอายุงาน (Gap)', 'placeholder' => 'เช่น 10-14.99'],
							'gap_min' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'ขั้นต่ำ', 'placeholder' => 'เช่น 10.00', 'step' => '0.01'],
							'gap_max' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'สูงสุด', 'placeholder' => 'เช่น 14.99', 'step' => '0.01'],
							'reference' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'รถอ้างอิง', 'placeholder' => 'เช่น 12.50', 'step' => '0.01'],
						],
					],
					'scheme' => [
						'status' => true,
						'input' => [
							'scheme_type' => ['type' => 'selection', 'status' => true, 'validate' => true, 'label' => 'ประเภทโครงการ', 'placeholder' => 'เลือกประเภทโครงการ', 'options' => ['manager' => 'Manager', 'sale' => 'Sale']],
							'range_min' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'ช่วงขั้นต่ำ', 'placeholder' => 'เช่น 0.83', 'step' => '0.01'],
							'range_max' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'ช่วงสูงสุด', 'placeholder' => 'เช่น 1.25', 'step' => '0.01'],
							'value_a' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'A - อัตราสิ้นเปลือง', 'placeholder' => 'เช่น 1.04', 'step' => '0.01', 'description' => 'อัตราการสิ้นเปลืองเชื้อเพลิงต่อกิโลเมตร'],
							'value_b' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'B - ค่าเสื่อมรถตามจริง', 'placeholder' => 'เช่น 1.20', 'step' => '0.01', 'description' => 'ค่าเสื่อมราคาของรถยนต์ตามการใช้งานจริง'],
							'value_c' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'C - แรงกระตุ้นให้เกิดการใช้รถ', 'placeholder' => 'เช่น 2.00', 'step' => '0.01', 'description' => 'แรงจูงใจหรือแรงกระตุ้นให้เกิดการใช้รถยนต์'],
							'rate' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'อัตรา (Rate)', 'placeholder' => 'เช่น 4.24', 'step' => '0.01'],
						],
					],
					'summary' => [
						'status' => false,
						'input' => [
							'km_l' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'A (Km/L)', 'placeholder' => 'Manager: 12.00, Sale: 16.78', 'step' => '0.01'],
							'multiplier' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'B (ตัวคูณ)', 'placeholder' => '1.20', 'step' => '0.01'],
							'rate_per_km' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'C (THB/Km)', 'placeholder' => 'Manager: 2.00, Sale: 3.00', 'step' => '0.01'],
							'credit' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'เชื่อ (Credit)', 'placeholder' => 'เช่น 2.25', 'step' => '0.01'],
						],
					],
					'rates' => [
						'status' => false,
						'input' => [
							'gap_value' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'ค่า GAP', 'placeholder' => 'เช่น 0.70', 'step' => '0.01'],
							'currency' => ['type' => 'input', 'status' => true, 'validate' => false, 'label' => 'หน่วยเงิน', 'placeholder' => 'THB/Km'],
						],
					],
					'other' => [
						'status' => false,
						'input' => [
							'remark' => ['type' => 'textarea', 'status' => true, 'validate' => false, 'label' => 'หมายเหตุ', 'placeholder' => 'หมายเหตุเพิ่มเติม (ถ้ามี)', 'rows' => 3],
						],
					],
				],
				'sidebar' => [
					'setting' => [
						'status' => false,
						'input' => [
							'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
						],
					]
				],
			],
		],

		'oil' => [
			'table' => [
				'header' => [
					['title' => 'ประเภทโครงการ', 'column' => 'scheme_type', 'orderable' => true, 'class' => 'text-center', 'status' => false],
					['title' => 'Gap ราคาน้ำมัน', 'column' => 'gap_range', 'orderable' => true, 'class' => '', 'status' => true],
					['title' => 'ราคาน้ำมัน', 'column' => 'reference', 'orderable' => true, 'class' => 'text-end', 'status' => true],
					['title' => 'อัตรา (Rate)', 'column' => 'rate', 'orderable' => false, 'class' => 'text-end', 'status' => false],
				],
				'filter' => [
					'scheme_type' => ['type' => 'select', 'url' => 'admin.oilprice.oilprice.get_scheme_type_list', 'status' => false],
				],
				'btn' => [
					'add' => true,
					'sort' => true,
					'default' => true,
					'status' => false,
					'edit' => true,
					'delete' => true,
					'export' => false,
				],
			],
			'form' => [
				'navbar' => [
					'basic' => [
						'status' => true,
						'input' => [
							'scheme_type' => ['type' => 'selection', 'status' => false, 'validate' => true, 'label' => 'ประเภทโครงการ', 'placeholder' => 'เลือกประเภทโครงการ', 'options' => ['manager' => 'Manager', 'sale' => 'Sale']],
							'gap_range' => ['type' => 'input', 'status' => true, 'validate' => true, 'label' => 'Gap ราคาน้ำมัน', 'placeholder' => 'เช่น 10-14.99'],
							'gap_min' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'ขั้นต่ำ', 'placeholder' => 'เช่น 10.00', 'step' => '0.01', 'disabled' => true],
							'gap_max' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'สูงสุด', 'placeholder' => 'เช่น 14.99', 'step' => '0.01', 'disabled' => true],
							'reference' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'ราคานํ้ามัน', 'placeholder' => 'เช่น 12.50', 'step' => '0.01'],
						],
					],
					'scheme' => [
						'status' => false,
						'input' => [
							'scheme_type' => ['type' => 'selection', 'status' => true, 'validate' => true, 'label' => 'ประเภทโครงการ', 'placeholder' => 'เลือกประเภทโครงการ', 'options' => ['manager' => 'Manager', 'sale' => 'Sale']],
							'range_min' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'ช่วงขั้นต่ำ', 'placeholder' => 'เช่น 0.83', 'step' => '0.01'],
							'range_max' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'ช่วงสูงสุด', 'placeholder' => 'เช่น 1.25', 'step' => '0.01'],
							'value_a' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'A - อัตราสิ้นเปลือง', 'placeholder' => 'เช่น 1.04', 'step' => '0.01', 'description' => 'อัตราการสิ้นเปลืองเชื้อเพลิงต่อกิโลเมตร'],
							'value_b' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'B - ค่าเสื่อมรถตามจริง', 'placeholder' => 'เช่น 1.20', 'step' => '0.01', 'description' => 'ค่าเสื่อมราคาของรถยนต์ตามการใช้งานจริง'],
							'value_c' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'C - แรงกระตุ้นให้เกิดการใช้รถ', 'placeholder' => 'เช่น 2.00', 'step' => '0.01', 'description' => 'แรงจูงใจหรือแรงกระตุ้นให้เกิดการใช้รถยนต์'],
							'rate' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'อัตรา (Rate)', 'placeholder' => 'เช่น 4.24', 'step' => '0.01'],
						],
					],
					'summary' => [
						'status' => false,
						'input' => [
							'km_l' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'A (Km/L)', 'placeholder' => 'Manager: 12.00, Sale: 16.78', 'step' => '0.01'],
							'multiplier' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'B (ตัวคูณ)', 'placeholder' => '1.20', 'step' => '0.01'],
							'rate_per_km' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'C (THB/Km)', 'placeholder' => 'Manager: 2.00, Sale: 3.00', 'step' => '0.01'],
							'credit' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'เชื่อ (Credit)', 'placeholder' => 'เช่น 2.25', 'step' => '0.01'],
						],
					],
					'rates' => [
						'status' => false,
						'input' => [
							'gap_value' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'ค่า GAP', 'placeholder' => 'เช่น 0.70', 'step' => '0.01'],
							'currency' => ['type' => 'input', 'status' => true, 'validate' => false, 'label' => 'หน่วยเงิน', 'placeholder' => 'THB/Km'],
						],
					],
					'other' => [
						'status' => false,
						'input' => [
							'remark' => ['type' => 'textarea', 'status' => true, 'validate' => false, 'label' => 'หมายเหตุ', 'placeholder' => 'หมายเหตุเพิ่มเติม (ถ้ามี)', 'rows' => 3],
						],
					],
				],
				'sidebar' => [
					'setting' => [
						'status' => false,
						'input' => [
							'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
						],
					]
				],
			],
			'setting' => [
				'limit' => [
					'status' => false,
					'max' => 1,
				],
				'limit_default' => [
					'status' => true,
					'max' => 1,
				],
			],
		],

		'permission' => [
			'table' => [
				'header' => [
					['title' => 'ประเภทโครงการ', 'column' => 'scheme_type', 'orderable' => true, 'class' => 'text-center', 'status' => false],
					['title' => 'Gap ราคาน้ำมัน', 'column' => 'gap_range', 'orderable' => true, 'class' => '', 'status' => true],
					['title' => 'รถอ้างอิง', 'column' => 'reference', 'orderable' => true, 'class' => 'text-end', 'status' => true],
					['title' => 'A - อัตราสิ้นเปลือง', 'column' => 'value_a', 'orderable' => true, 'class' => 'text-end', 'status' => true],
					['title' => 'B - ค่าเสื่อมรถตามจริง', 'column' => 'value_b', 'orderable' => true, 'class' => 'text-end', 'status' => true],
					['title' => 'C - แรงกระตุ้นให้เกิดการใช้รถ', 'column' => 'value_c', 'orderable' => true, 'class' => 'text-end', 'status' => true],
					['title' => 'อัตรา (Rate)', 'column' => 'rate', 'orderable' => false, 'class' => 'text-end', 'status' => false],
				],
				'filter' => [
					'scheme_type' => ['type' => 'select', 'url' => 'admin.oilprice.oilprice.get_scheme_type_list', 'status' => false],
				],
				'btn' => [
					'add' => true,
					'sort' => true,
					'default' => false,
					'status' => false,
					'edit' => true,
					'delete' => true,
					'export' => false,
				],
			],
			'form' => [
				'navbar' => [
					'basic' => [
						'status' => false,
						'input' => [
							'scheme_type' => ['type' => 'selection', 'status' => false, 'validate' => true, 'label' => 'ประเภทโครงการ', 'placeholder' => 'เลือกประเภทโครงการ', 'options' => ['manager' => 'Manager', 'sale' => 'Sale']],
							'gap_range' => ['type' => 'input', 'status' => true, 'validate' => true, 'label' => 'Gap ราคาน้ำมัน', 'placeholder' => 'เช่น 10-14.99'],
							'gap_min' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'ขั้นต่ำ', 'placeholder' => 'เช่น 10.00', 'step' => '0.01', 'disabled' => true],
							'gap_max' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'สูงสุด', 'placeholder' => 'เช่น 14.99', 'step' => '0.01', 'disabled' => true],
							'reference' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'ราคานํ้ามัน', 'placeholder' => 'เช่น 12.50', 'step' => '0.01'],
						],
					],
					'scheme' => [
						'status' => true,
						'input' => [
							'scheme_type' => ['type' => 'selection', 'status' => true, 'validate' => true, 'label' => 'ประเภทโครงการ', 'placeholder' => 'เลือกประเภทโครงการ', 'options' => ['manager' => 'Manager', 'sale' => 'Sale']],
							'range_min' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'ช่วงขั้นต่ำ', 'placeholder' => 'เช่น 0.83', 'step' => '0.01'],
							'range_max' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'ช่วงสูงสุด', 'placeholder' => 'เช่น 1.25', 'step' => '0.01'],
							'value_a' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'A - อัตราสิ้นเปลือง11', 'placeholder' => 'เช่น 1.04', 'step' => '0.01', 'description' => 'อัตราการสิ้นเปลืองเชื้อเพลิงต่อกิโลเมตร'],
							'value_b' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'B - ค่าเสื่อมรถตามจริง', 'placeholder' => 'เช่น 1.20', 'step' => '0.01', 'description' => 'ค่าเสื่อมราคาของรถยนต์ตามการใช้งานจริง'],
							'value_c' => ['type' => 'number', 'status' => true, 'validate' => true, 'label' => 'C - แรงกระตุ้นให้เกิดการใช้รถ', 'placeholder' => 'เช่น 2.00', 'step' => '0.01', 'description' => 'แรงจูงใจหรือแรงกระตุ้นให้เกิดการใช้รถยนต์'],
							'rate' => ['type' => 'number', 'status' => false, 'validate' => false, 'label' => 'อัตรา (Rate)', 'placeholder' => 'เช่น 4.24', 'step' => '0.01'],
						],
					],
					'summary' => [
						'status' => false,
						'input' => [
							'km_l' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'A (Km/L)', 'placeholder' => 'Manager: 12.00, Sale: 16.78', 'step' => '0.01'],
							'multiplier' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'B (ตัวคูณ)', 'placeholder' => '1.20', 'step' => '0.01'],
							'rate_per_km' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'C (THB/Km)', 'placeholder' => 'Manager: 2.00, Sale: 3.00', 'step' => '0.01'],
							'credit' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'เชื่อ (Credit)', 'placeholder' => 'เช่น 2.25', 'step' => '0.01'],
						],
					],
					'rates' => [
						'status' => false,
						'input' => [
							'gap_value' => ['type' => 'number', 'status' => true, 'validate' => false, 'label' => 'ค่า GAP', 'placeholder' => 'เช่น 0.70', 'step' => '0.01'],
							'currency' => ['type' => 'input', 'status' => true, 'validate' => false, 'label' => 'หน่วยเงิน', 'placeholder' => 'THB/Km'],
						],
					],
					'other' => [
						'status' => false,
						'input' => [
							'remark' => ['type' => 'textarea', 'status' => true, 'validate' => false, 'label' => 'หมายเหตุ', 'placeholder' => 'หมายเหตุเพิ่มเติม (ถ้ามี)', 'rows' => 3],
						],
					],
				],
				'sidebar' => [
					'setting' => [
						'status' => false,
						'input' => [
							'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
						],
					]
				],
			],
		],
	],
];
