<?php

namespace Modules\OilPrice\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Route;
use Modules\Mwz\app\Http\Controllers\AdminController;

class OilPricePermisstionController extends AdminController
{

    private $module, $method, $action, $config;

    /**
     * Function : construct
     * Dev : Wan
     * Update Date : 22 Jan 2025
     */
    public function __construct()
    {
        $routeName = Route::currentRouteName();
		if ($routeName) {
			$explode = explode('.', $routeName);
			$this->module = $explode[1] ?? '';
			$this->method = $explode[2] ?? '';
			$this->action = $explode[3] ?? '';
		} else {
			$this->module = '';
			$this->method = '';
			$this->action = '';
		}

        self::$navbar = [
            ['name' => __("oilprice::oilprice.{$this->method}.title"), 'url' => null],
            ['name' => __("oilprice::oilprice.{$this->method}.name"), 'url' => route_has("admin.{$this->module}.{$this->method}.index")]
        ];
        $this->config = config("oilprice.oilprice.{$this->method}");
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $limit = $this->config['setting']['limit_default'] ?? null;
        return view('oilprice::permission.form', [
            'navbar' => self::$navbar, 
            'config' => $this->config, 
            'method' => $this->method, 
            'type' => $this->module,
            'limit' => $limit,
            'action' => $this->action
        ]);
    }

    public function save(Request $request)
    {
        dd($request->all());
    }
}
