import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
	build: {
		outDir: '../../public/build-mwz',
		emptyOutDir: true,
		manifest: true,
	},
	plugins: [
		laravel({
			publicDirectory: '../../public',
			buildDirectory: 'build-mwz',
			input: [
				__dirname + '/resources/assets/sass/app.scss',
				// Global Language Loader (must be first)
				__dirname + '/resources/assets/js/lang-loader.js',
				// Language Text
				__dirname + '/resources/assets/js/lang.th.js',
				__dirname + '/resources/assets/js/lang.en.js',
				// Pages
				__dirname + '/resources/assets/js/log.js',
				__dirname + '/resources/assets/js/menu.js',
				__dirname + '/resources/assets/js/slug.js',
				__dirname + '/resources/assets/js/permission.js',
				// Plugins Setting
				__dirname + '/resources/assets/js/mwz.js',
				__dirname + '/resources/assets/js/select2.js',
				__dirname + '/resources/assets/js/upload.js',
				// Address
				__dirname + '/resources/assets/js/geo.js',
				__dirname + '/resources/assets/js/city.js',
				__dirname + '/resources/assets/js/zipcode.js',
				__dirname + '/resources/assets/js/province.js',
				__dirname + '/resources/assets/js/district.js',
			],
			refresh: true,
		}),
	],
});

//export const paths = [
//    'Modules/$STUDLY_NAME$/resources/assets/sass/app.scss',
//    'Modules/$STUDLY_NAME$/resources/assets/js/app.js',
//];