
$(document).ready(function () {
    // init for tag
    initDatatable();
})
window.initDatatable = function () {
    // =========================  tag =========================== //
    if ($("#tag-datatable").length > 0) {
        const oTable = $("#tag-datatable").DataTable({
            processing: true,
            serverSide: true,
            stateSave: true,
            dom: dom(),
            ajax: {
                url: "/admin/tag/datatable_ajax",
            },
            columns: [
                { data: "id", orderable: true, searchable: false, className: 'text-center' },
                { data: "type" },
                { data: "updated_at" },
                { data: "action", orderable: false, searchable: false },
            ],
            language: $_LANG.datatable,
        })
        init_Table();
    }
}
window.setReloadDataTable = function () {
    $("#tag-datatable").DataTable().ajax.reload(null, false);
}
window.setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($("#tag_frm")[0]);
    $.ajax({
        url: "/admin/tag/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
        beforeSend: function (xhr) {
            var frm = $("#tag_frm");
            // validate
            var rules = {
                type: { required: true },
                head: { required: true },
                body: { required: true },
                footer: { required: true },
            };

            var msg = {
                type: { required: $(frm).find('[name="type"]').attr('placeholder') },
                head: { required: $(frm).find('[name="head"]').attr('placeholder') },
                body: { required: $(frm).find('[name="body"]').attr('placeholder') },
                footer: { required: $(frm).find('[name="footer"]').attr('placeholder') },
            };

            mwz_validate($("#tag_frm"), rules, msg);
            var valid = $("#tag_frm").valid();
            if (valid) return valid;
            else {
                mwz_noti("error", $_LANG.validate.error);
                return valid;
            }
        },
        success: function (resp) {
            if (resp.success) mwz_noti("success", resp.msg), (location.replace("/admin/tag"))
            else mwz_noti("error", resp.msg);
        },
    });
};

window.setStatus = function (id) {
    $.ajax({
        url: "/admin/tag/set_status",
        type: "POST",
        data: { id: id },
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        success: function (resp) {
            if (resp.success) mwz_noti("success", resp.msg), setReloadDataTable();
            else mwz_noti("error", resp.msg), setReloadDataTable();
        },
    })
}, setDelete = function (id) {
    Swal.fire({
        icon: "warning",
        title: $_LANG.delete.title,
        text: $_LANG.delete.msg,
        showCancelButton: !0,
        confirmButtonText: $_LANG.delete.confirm,
        cancelButtonText: $_LANG.delete.cancel,
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "/admin/tag/set_delete",
                type: "POST",
                data: { id: id, },
                headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
                success: function (resp) {
                    if (resp.success) mwz_noti("success", resp.msg), setReloadDataTable();
                    else mwz_noti("error", resp.msg), setReloadDataTable();
                },
            });
        }
    })
}