
$(document).ready(function () {
    // init for slug
    initDatatable();
});
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
    // =========================  slug =========================== //
    if ($("#slug-datatable").length > 0) {
        $("#slug-datatable").DataTable({
            processing: true,
            serverSide: true,
            stateSave: true,
            ajax: {
                url: "/admin/slug/datatable_ajax",
            },
            columns: [
                { data: "DT_RowIndex", orderable: true, className: 'text-center' },
                { data: "slug" },
                { data: "module" },
                { data: "method" },
                { data: "updated_at" },
                { data: "action", orderable: false, className: 'text-center' },
            ],
            language: $_LANG.datatable,
        })
        init_Table();
    }
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function () {
    ($("#slug-datatable").length > 0) &&
        $("#slug-datatable").DataTable().ajax.reload(null, false);
};
/**
* Function : Init Icon
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($("#slug_frm")[0]);
    $.ajax({
        url: "/admin/slug/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
        success: function (resp) { mwz_noti("success", resp.msg, window.location.replace("/admin/slug")) },
        error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
    });
};
/**
* Function : Set Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setStatus = function (id) {
    event.preventDefault();
    $.ajax({
        url: "/admin/slug/set_status",
        type: "POST",
        data: { id: id },
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
        error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
    })
};
/**
* Function : Delete data by id
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
    event.preventDefault();
    $.ajax({
        url: "/admin/slug/set_delete",
        type: "POST",
        data: { id: id, },
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
        error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
    });
}