$(document).ready(function () {
	init_mwz_select2();
	select2AjaxWithImage();
	select2AjaxWithImageMultiple();
	select2AjaxTags();
	initSelectLang();
});
/**
* Function : init Select 2 Lang
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initSelectLang = function (selecter = '.mwz-select-lang') {
	$(document).find(selecter).each(function (index) {
		$(this).select2({
			theme: "bootstrap-5",
			placeholder: $(this).attr("placeholder"),
			templateResult: Select2Option,
			templateSelection: Select2Option,
			minimumResultsForSearch: Infinity,
		})
		lang_toggle($(this).val());
		$(this).change(function () {
			lang_toggle($(this).val());
		});
	})
}
/**
* Function : init toggle switch lang
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.lang_toggle = function (lang) {
	($('.lang-content').length > 0) &&
		$('.lang-content').removeClass('active')
			.each(function () {
				if ($(this).data('lang') == lang) {
					$(this).addClass('active');
				}
			});
	($('.nav-flag').length > 0) &&
		$('.nav-flag').find('i').removeClass().addClass(`flag flag-${lang}`);
}


/**
* Function : init elect2 noemal
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.init_mwz_select2 = function (reset = false) {
	($(".select2-show-search").length > 0) &&
		$(".select2-show-search").select2({ theme: "bootstrap-5", minimumResultsForSearch: "" });

	($(".select2").length > 0) &&
		$(".select2").each(function () {
			var placeholder = $(this).attr("placeholder");
			(typeof placeholder == undefined || placeholder == '') &&
				(placeholder = $_LANG.label.all);
			var clear = $(this).data("clear");
			$(this).select2({
				theme: "bootstrap-5",
				allowClear: clear ?? false,
				placeholder: placeholder,
				minimumResultsForSearch: Infinity,
			});
		});

	($(".select2multiple").length > 0) &&
		$(".select2multiple").select2({ theme: "bootstrap-5", multiple: true });

};

/**
* Function : init Select 2 Ajax With Image
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.select2AjaxWithImage = function (selecter = ".select2-ajax-with-image") {
	$(document).find(selecter).each(function (index) {
		var select = $(this);

		if ($(this).hasClass("select2-hidden-accessible")) {
			// $(select).select2("destroy")
			$(this).removeClass("select2-hidden-accessible");
			$(this).parent().find('.select2-container').remove();
		}

		if (!$(this).hasClass("select2-hidden-accessible")) {
			var url = $(this).data("url");
			var lang_placeholder = $(this).attr("placeholder");
			var clear = $(this).data("clear");
			var ele = $(this).select2({
				theme: "bootstrap-5",
				placeholder: lang_placeholder,
				allowClear: clear ?? false,
				templateResult: Select2Option,
				templateSelection: Select2Option,
				minimumInputLength: 0,
				language: {
					searching: function () { return $_LANG.action.loading; },
					noResults: function () { return $_LANG.action.zeroRecords; },
				},
				ajax: {
					url: url,
					type: "POST",
					data: function (params) {
						var parent = { search: params.term };
						var pid = $(this).data("parent-id");
						(typeof pid !== 'undefined' && pid != "") &&
							$.each(pid.split(','), function (index, e) {
								parent[e] = $(`#${e}`).val()
							});

						var query = { parent };
						return query;
					},
					headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				},
			})

			// $(this).on('change', function () {
			//     var data = $(this).select2('data')[0];
			//     if (typeof data.id !== 'undefined' || data.id != "") {
			//         var param = { id: data.id, text: data.text };
			//         if (typeof data.code !== 'undefined' && data.code != "") {
			//             param.code = data.code;
			//         } else if (typeof data.flag !== 'undefined' && data.flag != "") {
			//             param.flag = data.flag;
			//         } else if (typeof data.image !== 'undefined' && data.image != "") {
			//             param.image = data.image;
			//         }
			//         $(select).data("selected", param);
			//     }
			// });

			var option = $(this).data("selected");
			if (typeof option !== 'undefined') {
				var op = new Option(option.text, option.id, true, true);
				if (typeof option.code !== 'undefined' && option.code != "") {
					$(op).data("code", option.code);
				} else if (typeof option.flag !== 'undefined' && option.flag != "") {
					$(op).data("flag", option.flag);
				} else if (typeof option.image !== 'undefined' && option.image != "") {
					$(op).data("image", option.image);
				}
				$(ele).append(op).trigger("change");
			}
		}
	});
}
/**
* Function : Select 2 Ajax With Image Multiple
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.select2AjaxWithImageMultiple = function (selecter = ".select2-ajax-with-image-multiple") {
	$(document).find(selecter).each(function (index) {
		var select = $(this);

		if ($(this).hasClass("select2-hidden-accessible")) {
			$(this).removeClass("select2-hidden-accessible");
			$(this).parent().find('.select2-container').remove();
		}

		if (!$(this).hasClass("select2-hidden-accessible")) {
			var ajax_url = $(this).data("url");
			var lang_placeholder = $(this).attr("placeholder");
			var max_select = $(this).data("max-select");

			var ele = $(this).select2({
				theme: "bootstrap-5",
				placeholder: lang_placeholder,
				allowClear: true,
				templateResult: Select2Option,
				templateSelection: Select2Option,
				minimumInputLength: 0,
				maximumSelectionLength: max_select,
				multiple: true,
				language: {
					searching: function () { return $_LANG.action.loading; },
					noResults: function () { return $_LANG.action.zeroRecords; },
				},
				ajax: {
					url: ajax_url,
					type: "POST",
					data: function (params) {
						var parent = { search: params.term };
						var pid = $(this).data("parent-id");
						(typeof pid !== 'undefined' && pid != "") &&
							$.each(pid.split(','), function (index, e) {
								parent[e] = $(`#${e}`).val()
							});

						var query = { parent };

						return query;
					},
					headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				},
			});

			$(this).on('change', function () {
				let data = $(this).select2('data')[0];
				if (typeof data !== 'undefined' && data.id != "") {
					let param = { id: data.id, text: data.text };

					['code', 'flag', 'image'].forEach(function (key) {
						if (typeof data[key] !== 'undefined' && data[key] != "")
							param[key] = data[key];
					});

					$(select).data("selected", param);
				}
			});

			var option = $(this).data("selected");
			if (option != "") {
				$.each(option, function (i, e) {
					var op = new Option(e.text, e.id, true, true);
					if (typeof e.code !== 'undefined' && e.code != "") {
						$(op).data("code", e.code);
					} else if (typeof e.flag !== 'undefined' && e.flag != "") {
						$(op).data("flag", e.flag);
					} else if (typeof e.image !== 'undefined' && e.image != "") {
						$(op).data("image", e.image);
					}
					$(ele).append(op).trigger("change");
				});
			}
		}
	});
}
/**
* Function : Select 2 Ajax Tags
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.select2AjaxTags = function (selecter = ".select2-ajax-tags", reset = false) {
	$(document).find(selecter).each(function (index) {
		if (reset) {
			($(this).hasClass("select2-hidden-accessible")) &&
				$(this).select2("destroy");
		}

		if (!$(this).hasClass("select2-hidden-accessible")) {
			var ajax_url = $(this).data("ajax-url");
			var lang_placeholder = $(this).data("lang-placeholder");

			var $ele = $(this).select2({
				theme: "bootstrap-5",
				placeholder: lang_placeholder,
				allowClear: true,
				templateResult: Select2Option,
				templateSelection: Select2Option,
				minimumInputLength: 0,
				multiple: true,
				tags: true,
				tokenSeparators: [","],
				language: {
					searching: function () { return $_LANG.action.loading; },
					noResults: function () { return $_LANG.action.zeroRecords; },
				},
				ajax: {
					url: ajax_url,
					type: "POST",
					data: function (params) {
						var parent = { search: params.term };
						var pid = $(this).data("parent-id");
						(typeof pid !== 'undefined' && pid != "") &&
							$.each(pid.split(','), function (index, e) {
								parent[e] = $(`#${e}`).val()
							});

						var query = { parent };
						return query;
					},
					headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				},
				createTag: function (params) {
					var term = $.trim(params.term);
					if (term === "") return null;
					return { id: term, text: term, newTag: true };
				},
				insertTag: function (data, tag) { data.push(tag); },
			});


			var option_id = $(this).data("selected-id");
			var option_text = $(this).data("selected-text");
			if (option_id != "") {
				var option_id = option_id.split(",");
				$.each(option_id, function (i, tag) {
					var data = { id: tag, text: tag };
					var newOption = new Option(data.text, data.id, true, true);
					$($ele).append(newOption).trigger("change");
				});
			}
		}
	});
};

/**
* Function : Select 2 format Selected
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.Select2Option = function (opt, container) {
	var image_url = $(opt.element).data("image");
	var flag = $(opt.element).data("flag");
	var code = $(opt.element).data("code");
	var html = `<div class=\"select-option\" data-id=\"${opt.id}\">`;
	if (typeof opt.image !== 'undefined' && opt.image != "") {
		html += `<div class=\"option-image\"><img src=\"${opt.image}\" class=\"img-fluid\" /></div>`;
	} else if (typeof image_url !== 'undefined' && image_url != "") {
		html += `<div class=\"option-image\"><img src=\"${image_url}\" class=\"img-fluid\" /></div>`;
	} else if (typeof opt.flag !== 'undefined' && opt.flag != "") {
		html += `<div class=\"${opt.flag}\"></div>`;
	} else if (typeof flag !== 'undefined' && flag != "") {
		html += `<div class=\"${flag}\"></div>`;
	} else if (typeof opt.code !== 'undefined' && opt.code != "") {
		html += `<div class=\"option-code\" style=\"background-color:${opt.code};\"></div>`;
	} else if (typeof code !== 'undefined' && code != "") {
		html += `<div class=\"option-code\" style=\"background-color:${code};\"></div>`;
	}
	html += `<div class=\"option-text\">${opt.text}</div>`;
	html += `</div>`;
	return $(html);
}