$(document).ready(function () {
	initDatatable();
	initTree();
	initIcon();
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	if ($("#menu-datatable").length > 0) {
		$("#menu-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/admin_menu/datatable_ajax",
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: [
				{ data: "DT_RowIndex", orderable: true, className: "text-center" },
				{ data: "icon", className: "text-center", orderable: false },
				{ data: "name", orderable: true },
				{ data: "link", orderable: false },
				{ data: "sort", orderable: false, className: 'text-center' },
				{ data: "updated_at", orderable: true },
				{ data: "action", orderable: false, className: 'text-center' }
			],
			language: $_LANG.datatable,
		})
		init_Table();
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function () {
	($("#menu-datatable").length > 0) &&
		$("#menu-datatable").DataTable().ajax.reload(null, false);
}
/**
* Function : Init Icon
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initIcon = function () {
	if ($(".icon-selector").length > 0) {
		$.ajax({
			url: "/admin/admin_menu/icons",
			type: "GET",
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				var selector = $('.icon-selector').fontIconPicker({
					theme: 'fip-grey',
					source: resp,
					appendTo: 'self',
				});
				selector.setIcon($('.icon-selector').val())
			},
			error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown) }
		})
	}
}
/**
* Function : Set Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setStatus = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/admin_menu/set_status",
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown) }
	})
}
/**
* Function : Delete data by id
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/admin_menu/set_delete",
		type: "POST",
		data: { id: id, },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown) }
	});
};
/**
* Function : Sort Item
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSort = function (id, move) {
	event.preventDefault();
	$.ajax({
		url: "/admin/admin_menu/set_sort",
		type: "POST",
		data: { id: id, move: move },
		headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		success: function (resp) { setReloadDataTable(); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown) }
	});
};
/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();
	var frm = $("#menu_frm");
	var frm_data = new FormData($(frm)[0]);
	$.ajax({
		url: "/admin/admin_menu/save",
		type: "POST",
		data: frm_data,
		contentType: false,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
		beforeSend: function (xhr) {
			// validate
			var rules = { name: { required: true, maxlength: 255 } };
			var messages = $_LANG.validate.messages;

			mwz_validate($(frm), rules, messages);
			return frm_valid($(frm));
		},
		success: function (resp) { mwz_noti("success", resp.msg, window.location.replace("/admin/admin_menu/")); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	});
};
/**
* Function : Init Tree
* Dev : Peh
* Update Date : 26 Apr 2024
*/
window.initTree = function () {
	if ($('#tree_view').length > 0) {
		$("#tree_view").jstree({
			core: {
				check_callback: !0,
				themes: { responsive: !1 }
			},
			plugins: ["types", "dnd"]
		});
		$('#tree_view').on('move_node.jstree', function (event, data) {
			var id = $(`#${data.node.id}`).data('id');
			if (data.node.parent == '#') {
				setTreeSort(id, 0, data.position, data.old_position);
			} else {
				setTreeSort(id, $(`#${data.node.parent}`).data('id'), data.position, data.old_position);
			}
		});
	}
};
/**
* Function : sort Tree
* Dev : Peh
* Update Date : 26 Apr 2024
*/
window.setTreeSort = function (id, parent_id, position, old_position) {
	event.preventDefault();
	$.ajax({
		url: "/admin/admin_menu/tree/sort",
		type: "POST",
		data: {
			id: id,
			parent_id: parent_id,
			position: position,
			old_position: old_position,
		},
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		success: function (resp) { mwz_noti('success', resp.msg) },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown) }
	});
}