window.$_LANG = {
    action: {
        add: 'เพิ่ม',
        filter: 'กรอง',
        manage: 'จัดการ',
        import: 'นำเข้า',
        export: 'ส่งออก',
        no_data: 'ไม่พบข้อมูล',
        zeroRecords: "ไม่พบรายการที่ค้นหา",
        loading: 'กำลังโหลดข้อมูล',
        search: 'ค้นหา...',
    },
    label: {
        all: 'ทั้งหมด',
    },
    ajax: {
        error: 'เกิดข้อผิดพลาด กรุณาลองอีกครั้ง',
    },
    datatable: {
        lengthMenu: "_MENU_ รายการ",
        zeroRecords: "ขออภัย - ไม่พบรายการ",
        decimal: "",
        emptyTable: "ไม่พบข้อมูล",
        info: "_START_-_END_ จาก _TOTAL_ รายการ",
        infoEmpty: "ไม่พบรายการ",
        infoFiltered: "(กรองข้อมูลจาก _MAX_ รายการ)",
        infoPostFix: "",
        thousands: ",",
        loadingRecords: "กำลังโหลด...",
        processing: "กำลังโหลด...",
        search: "",
        searchPlaceholder: "ค้นหา...",
        paginate: {
            first: "หน้าแรก",
            last: "หน้าสุดท้าย",
            next: "ถัดไป",
            previous: "ก่อนหน้า",
        },
        aria: {
            sortAscending: ": เรียงข้อมูลจากน้อยไปมาก",
            sortDescending: ": เรียงข้อมูลจากมากไปน้อย",
        },
    },
    delete: {
        title: "ลบข้อมูล",
        msg: "ยืนยันลบ ?",
        confirm: "ยืนยัน",
        cancel: "ยกเลิก",
    },
    send_email: {
        title: "ส่งอีเมล",
        msg: "ยืนยันส่งอีเมล ?",
        confirm: "ยืนยัน",
        cancel: "ยกเลิก",
    },
    validate: {
        messages: {
            name_th: {
                required: "โปรดระบุชื่อภาษาไทย",
                maxlength: "กรุณาระบุชื่อหัวข้อภาษาไทยไม่เกิน {0} ตัวอักษร",
            },
            name_en: {
                required: "โปรดระบุชื่อภาษาอังกฤษ",
                maxlength: "กรุณาระบุชื่อหัวข้อภาษาอังกฤษไม่เกิน {0} ตัวอักษร",
            },
            rank_th: {
                required: "โปรดระบุตำแหน่งภาษาไทย",
                maxlength: "กรุณาระบุตำแหน่งภาษาไทยไม่เกิน {0} ตัวอักษร",
            },
            rank_en: {
                required: "โปรดระบุตำแหน่งภาษาอังกฤษ",
                maxlength: "กรุณาระบุตำแหน่งภาษาอังกฤษไม่เกิน {0} ตัวอักษร",
            },
            desc_th: {
                required: "โปรดระบุคำอธิบายภาษาไทย",
                maxlength: "กรุณาระบุคำอธิบายภาษาไทยไม่เกิน {0} ตัวอักษร",
            },
            desc_en: {
                required: "โปรดระบุคำอธิบายภาษาอังกฤษ",
                maxlength: "กรุณาระบุคำอธิบายภาษาอังกฤษไม่เกิน {0} ตัวอักษร",
            },
            detail_th: {
                required: "โปรดระบุรายละเอียดภาษาไทย",
            },
            detail_en: {
                required: "โปรดระบุรายละเอียดภาษาอังกฤษ",
            },

            brand_id: {
                required: "โปรดเลือกยี่ห้อ",
            },
            menu_id: {
                required: "โปรดเลือกเมนู",
            },
            amount: {
                required: "โปรดระบุส่วนลด",
            },
            start: {
                required: "โปรดระบุวันที่เริ่ม",
            },
            expire: {
                required: "โปรดระบุวันที่สิ้นสุด",
            },
            password: {
                required: "โปรดระบุรหัสผ่าน",
                minlength: "รหัสผ่านต้องมีอย่างน้อย {0} ตัวอักษร",
                maxlength: "รหัสผ่านต้องมีอย่างไม่เกิน {0} ตัวอักษร",
                regex: "รหัสผ่านต้องประกอบไปด้วยตัวอักษรและตัวเลข",
            },
            re_password: {
                required: "โปรดระบุรหัสผ่าน",
                minlength: "รหัสผ่านต้องมีอย่างน้อย {0} ตัวอักษร",
                maxlength: "รหัสผ่านต้องมีอย่างไม่เกิน {0} ตัวอักษร",
                regex: "รหัสผ่านต้องประกอบไปด้วยตัวอักษรและตัวเลข",
                equalTo: "รหัสผ่านไม่ตรงกัน",
            },
        },
        error: "กรุณากรอกข้อมูลให้ถูกต้อง",
    },
    jquery_validate: {
        required: "กรุณากรอกข้อมูล",
        remote: "กรุณาตรวจสอบข้อมูล",
        email: "กรุณากรอกอีเมลที่ถูกต้อง",
        url: "กรุณากรอก URL ที่ถูกต้อง",
        date: "กรุณากรอกวันที่ที่ถูกต้อง",
        dateISO: "กรุณากรอกวันที่ที่ถูกต้อง (ISO)",
        number: "กรุณากรอกตัวเลข",
        digits: "กรุณากรอกเฉพาะตัวเลข",
        creditcard: "กรุณากรอกหมายเลขบัตรเครดิตที่ถูกต้อง",
        equalTo: "กรุณากรอกข้อมูลให้ตรงกัน",
        accept: "กรุณาเลือกไฟล์ที่มีนามสกุลที่ถูกต้อง",
        maxlength: function(param) { return "กรุณากรอกข้อมูลไม่เกิน " + param + " ตัวอักษร"; },
        minlength: function(param) { return "กรุณากรอกข้อมูลอย่างน้อย " + param + " ตัวอักษร"; },
        rangelength: function(param) { return "กรุณากรอกข้อมูลระหว่าง " + param[0] + " ถึง " + param[1] + " ตัวอักษร"; },
        range: function(param) { return "กรุณากรอกข้อมูลระหว่าง " + param[0] + " ถึง " + param[1]; },
        max: function(param) { return "กรุณากรอกข้อมูลไม่เกิน " + param; },
        min: function(param) { return "กรุณากรอกข้อมูลอย่างน้อย " + param; },
    },
    noti: {
        success: 'บันทึกการเปลี่ยนแปลงสำเร็จ',
        error: 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง',
        warning: 'คำเตือน',
        info: 'ข้อมูล',
        delete_success: 'ลบรายการสำเร็จ',
        save_success: 'บันทึกข้อมูลสำเร็จ',
        update_success: 'อัปเดตข้อมูลสำเร็จ',
        upload_success: 'อัปโหลดสำเร็จ',
        upload_error: 'เกิดข้อผิดพลาดในการอัปโหลด',
        file_too_large: 'ไฟล์มีขนาดใหญ่เกินไป',
        invalid_file_type: 'ประเภทไฟล์ไม่ถูกต้อง',
        network_error: 'เกิดข้อผิดพลาดในการเชื่อมต่อเครือข่าย',
        server_error: 'เกิดข้อผิดพลาดที่เซิร์ฟเวอร์',
        validation_error: 'กรุณาตรวจสอบข้อมูลที่กรอก',
        email_required: 'กรุณากรอกอีเมล',
        email_invalid: 'รูปแบบอีเมลไม่ถูกต้อง',
        email_missing_at: 'อีเมลต้องมี @',
        email_validation_error: 'กรุณาตรวจสอบอีเมลให้ถูกต้องก่อนส่งฟอร์ม',
    },
};

// Apply jQuery validation messages when document is ready
document.addEventListener('DOMContentLoaded', function() {
    if (typeof $.validator !== 'undefined' && window.$_LANG && window.$_LANG.jquery_validate) {
        // Override jQuery validation messages with language-specific ones
        $.extend($.validator.messages, window.$_LANG.jquery_validate);
    }
});
