<?php

namespace Modules\Mwz\database\seeders;

use Illuminate\Database\Seeder;
use Modules\Mwz\app\Models\AdminMenus;

class MwzMenuSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 */
	public function run(): void
	{
		$data = [
			['icon' => 'mdi mdi-cog-outline', 'name' => 'ตั้งค่า', 'status' => 1],
			['icon' => 'mdi mdi-account-key', 'name' => 'ผู้ดูแลระบบ', 'status' => 1],
			['name' => 'เว็บไซต์', 'parent_id' => 1, 'status' => 1],
			['name' => 'Language', 'parent_id' => 1, 'status' => 1],
			['name' => 'Tag Analytics', 'parent_id' => 1, 'status' => 1],
			['name' => 'จัดการไฟล์', 'parent_id' => 1, 'status' => 1],
			['name' => 'Errors', 'parent_id' => 1, 'status' => 0],
			['name' => 'SMTP', 'parent_id' => 1, 'status' => 0],
			['name' => 'Robots.txt', 'parent_id' => 1, 'status' => 0],
			['name' => 'รายชื่อ', 'parent_id' => 2, 'status' => 1],
			['name' => 'สิทธิ์การใช้งาน', 'parent_id' => 2, 'status' => 1],
		];

		foreach ($data as $item)
			AdminMenus::updateOrCreate($item);
	}
}
