<?php

namespace Modules\Mwz\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Mwz\Database\factories\SlugsFactory;

class Slugs extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = ['id', 'uid', 'level', 'type', 'module', 'method', 'data_id', 'lang', 'slug', 'param', 'meta_auther', 'meta_title', 'meta_keywords', 'meta_description', 'meta_image', 'meta_robots', 'status', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "mwz_slugs";
    protected $primaryKey = "id";

    protected static function newFactory(): SlugsFactory
    {
        return SlugsFactory::new();
    }

    public function langs()
    {
        return $this->hasMany(Slugs::class, 'uid', 'uid');
    }

    public function locale()
    {
        return $this->hasOne(Slugs::class, 'uid', 'uid')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
}
