<?php

namespace Modules\Mwz\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Mwz\Database\factories\ProvincesFactory;

class Provinces extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'geo_id', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "mwz_provinces";
    protected $primaryKey = "id";

    protected static function newFactory(): ProvincesFactory
    {
        return ProvincesFactory::new();
    }
    protected static function boot(): void
    {
        parent::boot();
        static::deleting(function ($model) {
            $model->langs()->delete();
        });
    }
    public function langs()
    {
        return $this->hasMany(ProvinceTranslate::class, 'province_id', 'id');
    }
    public function local()
    {
        return $this->hasOne(ProvinceTranslate::class, 'province_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
    public function geo()
    {
        return $this->hasOne(Geographies::class, 'id', 'geo_id');
    }
}
