<?php

namespace Modules\Mwz\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Mwz\Database\factories\GeographiesFactory;

class Geographies extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "mwz_geo";
    protected $primaryKey = "id";

    protected static function newFactory(): GeographiesFactory
    {
        return GeographiesFactory::new();
    }
    protected static function boot(): void
    {
        parent::boot();
        static::deleting(function ($model) {
            $model->langs()->delete();
        });
    }
    public function langs()
    {
        return $this->hasMany(GeographyTranslate::class, 'geo_id', 'id');
    }
    public function local()
    {
        return $this->hasOne(GeographyTranslate::class, 'geo_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
}
