<?php

namespace Modules\Mwz\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Mwz\Database\factories\CitiesFactory;

class Cities extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'geo_id', 'province_id', 'district_id', 'zipcode', 'latitude', 'longitude', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "mwz_city";
    protected $primaryKey = "id";

    protected static function newFactory(): CitiesFactory
    {
        return CitiesFactory::new();
    }
    protected static function boot(): void
    {
        parent::boot();
        static::deleting(function ($model) {
            $model->langs()->delete();
        });
    }
    public function langs()
    {
        return $this->hasMany(CityTranslate::class, 'city_id', 'id');
    }
    public function local()
    {
        return $this->hasOne(CityTranslate::class, 'city_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
    public function geo()
    {
        return $this->hasOne(Geographies::class, 'id', 'geo_id');
    }
    public function province()
    {
        return $this->hasOne(Provinces::class, 'id', 'province_id');
    }
    public function district()
    {
        return $this->hasOne(Districts::class, 'id', 'district_id');
    }
}
