<?php

namespace Modules\Mwz\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Kalnoy\Nestedset\NodeTrait;

class AdminMenus extends Model
{
	use HasFactory, NodeTrait;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'icon',
		'name',
		'permission_id',
		'_lft',
		'_rgt',
		'parent_id',
		'sequence',
		'status',
	];
	protected $table = 'mwz_menus';
	protected $primaryKey = 'id';

	public function permission()
	{
		return $this->hasOne(Permissions::class, 'id', 'permission_id')->select(['id', 'name', 'route_name', 'role']);
	}

	public function parent()
	{
		return $this->hasOne(AdminMenus::class, 'id', 'parent_id')->where('status', 1);
	}

	public function child()
	{
		return $this->hasMany(AdminMenus::class, 'parent_id', 'id')->with(['child', 'permission'])->where('status', 1)->orderBy('_lft')->select('id', 'icon', 'name', 'permission_id', 'parent_id', '_lft');
	}
}
