<?php

namespace Modules\Mwz\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Validator;
use Modules\Mwz\app\Models\Tags;
use Yajra\DataTables\Facades\DataTables;

class TagAdminController extends  AdminController
{
    public function __construct()
    {
        $this->middleware('auth:admin');
        $this->navbar[] =  ['name' => __('mwz::tag.title'), 'url' => null];
        $this->navbar[] =  ['name' => __('mwz::tag.name'), 'url' => route_has('admin.mwz.tag.index')];
    }
    public function index()
    {
        return view('mwz::tag.index', ['navbar' => $this->navbar]);
    }

    public function datatable_ajax(Request $request)
    {
        if ($request->ajax()) {
            //init datatable
            $dt_column = array('id', 'type', 'updated_at');
            $dt_order = $request->get('order')[0]['column'];
            $dt_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // create brand object
            $req = new Tags();

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $req = $req->where('type', 'like', "%" . $dt_search . "%")
                    ->orWhere('head', 'like', "%" . $dt_search . "%")
                    ->orWhere('updated_at', 'like', "%" . $dt_search . "%");
            }

            $dt_total = $req->count();
            // set query order & limit from datatable
            $resp = $req->orderBy($dt_column[$dt_order], $dt_dir)
                ->offset($dt_start)->limit($dt_length)
                ->get();

            // query brand
            // prepare datatable for response
            $tables = DataTables::of($resp)
                ->addIndexColumn()
                ->setRowId('id')
                ->setRowClass('tag_row')
                ->setTotalRecords($dt_total)
                ->setFilteredRecords($dt_total)
                ->setOffset($dt_start)
                ->editColumn('head', function ($record) {
                    return limit($record->head, 60);
                })
                ->editColumn('updated_at', function ($record) {
                    return $record->updated_at->format('Y-m-d H:i');
                })
                ->addColumn('action', function ($record) {
                    $btn = '<div class="d-flex flex-nowrap gap-1">';
                    $btn .= $this->btn_status('admin.setting.tag.set_status', $record->id, 'setStatus', $record->status);
                    $btn .= $this->btn_route('admin.setting.tag.edit', $record->id);
                    $btn .= $this->btn_delete('admin.setting.tag.set_delete', $record->id, 'setDelete');
                    $btn .= '</div>';

                    return $btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

    public function form($id = 0)
    {
        $this->navbar[] = ['name' => !empty($id) ? __('admin.action.edit') : __('admin.action.add'), 'url' => null];
        $data = [];
        if (!empty($id)) $data = Tags::find($id);

        return view('mwz::tag.form', ['data' => $data, 'navbar' => $this->navbar]);
    }

    public function save(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'head' => 'required',
            'body' => 'required',
            'footer' => 'required',
        ], [
            'type.required' => __('mwz::tag.field.type_placeholder'),
            'head.required' => __('mwz::tag.field.head_placeholder'),
            'body.required' => __('mwz::tag.field.body_placeholder'),
            'footer.required' => __('mwz::tag.field.footer_placeholder'),
        ]);


        if ($validator->fails())
            return response()->json(['success' => 0, 'code' => 301, 'msg' => $validator->errors()->first(), 'error' => $validator->errors()]);

        $attr = [
            'type' => $request->get('type'),
            'head' => ($request->get('head')),
            'body' => ($request->get('body')),
            'footer' => ($request->get('footer')),
            'status' => $request->get('status') ?? 0
        ];
        $set = Tags::updateOrcreate(['id' => $request->get('id')], $attr);
        if ($set->save()) return response()->json(['success' => 1, 'code' => 300, 'msg' => __('admin.resp.success')]);
        else return response()->json(['success' => 0, 'code' => 300, 'msg' => __('admin.resp.error')]);
    }

    public function set_status(Request $request)
    {
        if ($request->ajax()) {
            $set = Tags::find($request->get('id'));
            $set->status = !$set->status;
            if ($set->save()) return response()->json(['success' => 1, 'code' => 300, 'msg' => __('admin.resp.success')]);
            else return response()->json(['success' => 0, 'code' => 300, 'msg' => __('admin.resp.error')]);
        }
    }

    public function set_delete(Request $request)
    {
        if ($request->ajax()) {
            $set = Tags::find($request->get('id'));
            if ($set->delete()) return response()->json(['success' => 1, 'code' => 300, 'msg' => __('admin.resp.delete')]);
            else return response()->json(['success' => 0, 'code' => 300, 'msg' => __('admin.resp.error')]);
        }
    }
}
