<?php

namespace Modules\Mwz\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use Modules\Mwz\app\Models\Slugs;

class SlugController extends AdminController
{
	/**
	 * Function : get slug
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function getSlug($slug)
	{
		$lang = app()->getLocale() ?? config('app.fallback_locale');
		$o_slugs = Slugs::where([['slug', $slug], ['lang', $lang], ['status', 1]])->first();
		$switch = [];
		if (!empty($o_slugs->langs)) {
			foreach ($o_slugs->langs as $slg) {
				$switch[$slg->lang] = (config('app.fallback_locale') == $slg->lang ? "/" : "/{$slg->lang}/") . $slg->slug;
			}
		}
		return ['slug' => $o_slugs, 'lang_switch' => $switch];
	}

	public static function slug($slug)
	{
		$slug = Slugs::where(function ($query) use ($slug) {
			$query->where('slug', $slug)
				->where('lang', app()->getLocale() ?? config('app.fallback_locale'))
				->where('status', 1);
		})->first();
		if (!empty($slug->langs)) {
			$switch = [];
			foreach ($slug->langs as $slg) {
				$switch[$slg->lang] = (config('app.fallback_locale') == $slg->lang ? "/" : "/{$slg->lang}/") . $slg->slug;
			}
			$slug->switch = $switch;
		}
		return $slug;
	}

	/**
	 * Function : get slug by id
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function getSlugById($id)
	{
		$slug = Slugs::find($id);
		$data = [];
		if (!empty($slug->langs)) {
			foreach ($slug->langs as $slg) {
				$data['url'][$slg->lang] = ((config('app.fallback_locale') == $slg->lang) ? "/" : "/{$slg->lang}/") . $slg->slug;
			}
		}
		return $data;
	}

	/**
	 * Function : get slug string
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function slug_Id($id): string
	{
		$lang = app()->getLocale() ?? config('app.fallback_locale');
		$req = Slugs::find($id);
		return ($lang != config('app.fallback_locale') ? "/{$lang}/" : '/') . ($req->locale->slug ?? '');
	}

	/**
	 * Function : get slug url
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function getSlugUrl($module, $method, $id = 1)
	{
		$data = [];
		$slug = Slugs::where([['module', $module], ['method', $method], ['data_id', $id]])->first();
		if (!empty($slug->langs)) {
			foreach ($slug->langs as $slg) {
				$data['url'][$slg->lang] = ((config('app.fallback_locale') == $slg->lang) ? "/" : "/{$slg->lang}/") . $slg->slug;
			}
		}
		return $data;
	}

/**
	 * Function : get route by module
	 * Dev : Wan
	 * Update Date : 29 Apr 2024
	 */
	public static function getRouteSub($module, $method, $id = 1)
	{
		$lang = app()->getLocale() ?? config('app.fallback_locale');

		$slug = Slugs::where([['lang', $lang], ['module', $module], ['method', $method], ['data_id', $id]])->first();
		if (!empty($slug)) {
			return '/' . ($slug->slug ?? '');
		} else {
			return null;
		}
	}

	/**
	 * Function : get route by module
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function getRoute($module, $method, $id = 1)
	{
		$lang = app()->getLocale() ?? config('app.fallback_locale');
		$slug = Slugs::where([['lang', $lang], ['module', $module], ['method', $method], ['data_id', $id]])->first();

		if (!empty($slug))
			return ($lang == config('app.fallback_locale') ? '' : "/{$lang}") . '/' . ($slug->slug ?? '');

		return null;
	}

	/**
	 * Function : get route
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function get_route($module, $method, $id = 1): string
	{
		$lang = app()->getLocale() ?? config('app.fallback_locale');
		$slug = Slugs::where([['lang', $lang], ['module', $module], ['method', $method], ['data_id', $id]])->first();
		return $slug->slug ?? '';
	}

	/**
	 * Function : get meata data
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function getMetadata($module, $method, $id = 1)
	{
		$slugs = Slugs::where([['module', $module], ['method', $method], ['data_id', $id]])->get();
		$metadata = [];
		if (!empty($slugs)) {
			foreach ($slugs as $slug) {
				$metadata[$slug->lang] = [
					'uid' => $slug->uid,
					'slug' => $slug->slug,
					'level' => $slug->level,
					'module' => $slug->module,
					'method' => $slug->method,
					'data_id' => $slug->data_id,
					'param' => $slug->param,
					'auther' => $slug->meta_auther,
					'title' => $slug->meta_title,
					'keywords' => $slug->meta_keywords,
					'description' => $slug->meta_description,
					'robots' => $slug->meta_robots,
					'image' => $slug->meta_image
				];
			}
		}
		return $metadata;
	}

	/**
	 * Function : get meta data locale
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function meta_data_locale($module, $method, $id = 1)
	{
		$lang = app()->getLocale() ?? config('app.fallback_locale');
		$slug = Slugs::where([['lang', $lang], ['module', $module], ['method', $method], ['data_id', $id]])->first();
		$data = [];
		if (!empty($slug)) {
			$data = [
				'uid' => $slug->uid,
				'slug' => $slug->slug,
				'level' => $slug->level,
				'module' => $slug->module,
				'method' => $slug->method,
				'data_id' => $slug->data_id,
				'param' => $slug->param,
				'auther' => $slug->meta_auther,
				'title' => $slug->meta_title,
				'keywords' => $slug->meta_keywords,
				'description' => $slug->meta_description,
				'robots' => $slug->meta_robots,
				'image' => $slug->meta_image
			];
		}
		return $data;
	}

	/**
	 * Function : duplicate metadata
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function DuplicateMetadata($module, $method, $data_id, $new_id)
	{
		$slugs = Slugs::where('module', $module)->where('method', $method)->where('data_id', $data_id)->get();
		if (!empty($slugs)) {
			foreach ($slugs as $slug) {
				$new_slug = $slug->replicate();
				$new_slug->data_id = $new_id;
				$new_slug->slug = "$slug->slug-$new_id";
				$new_slug->created_at = date('Y-m-d H:i:s');
				$new_slug->updated_at = date('Y-m-d H:i:s');
				$new_save =  $new_slug->save();
				$new_slug->uid = "{$slug->module}-{$slug->method}-{$new_id}";
				$new_slug->save();
			}
		}
	}

	/**
	 * Function : check slug
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function checkSlug(Request $request)
	{
		$chk_slug = Slugs::where('lang', $request->get('lang'))->where('slug', $request->get('slug'))->first();
		if (!empty($chk_slug) && !empty($chk_slug->id)) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 * Function : create metadata
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function createMetadata(Request $request, $id = 0, $status = true)
	{
		$meta_image = check_file_upload($request, 'meta_image', 'image') ? null : self::set_image_upload($request, "meta_image", "public/meta/image", "meta_image-");
		if (!empty($request->get('meta'))) {
			foreach ($request->get('meta') as $lang => $meta) {
				$slug = $meta['slug'];
				if (($meta['module'] !== 'index' && $meta['method'] !== 'index') && Slugs::where([['lang', $lang], ['slug', $slug], ['uid', '<>', "{$meta['module']}-{$meta['method']}-{$id}"]])->count() > 0)
					$slug .= "-" . Str::random(4);

				$attr = [
					'slug' => self::createSlugText($slug),
					'level' => $meta['level'] ?? null,
					'module' =>  $meta['module'] ?? null,
					'method' =>  $meta['method'] ?? null,
					'data_id' => $id,
					'param' => !empty($meta['param']) ? json_encode($meta['param'], JSON_UNESCAPED_UNICODE) : null,
					'meta_title' => $meta['title'] ?? null,
					'meta_keywords' => $meta['keywords'] ?? null,
					'meta_description' => limit(strip_tags($meta['description'] ?? null), 200),
					'status' => $status
				];

				if (!empty($meta['auther']))
					$attr['meta_auther'] =  $meta['auther'] ?? null;
				if (!empty($meta['robots']))
					$attr['meta_robots'] = $meta['robots'] ?? null;
				if (!empty($meta_image))
					$attr['meta_image'] =  $meta_image;
				if (!empty($meta['slug']))
					Slugs::updateOrCreate(['lang' => $lang, 'uid' => "{$meta['module']}-{$meta['method']}-{$id}"], $attr);
			}
		}
	}

	public static function slug_status($module, $method, $id = 1, $status = true)
	{
		Slugs::where('uid', "{$module}-{$method}-{$id}")->update(['status' => $status]);
	}

	/**
	 * Function : update slug
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function updateSlug($id, $lang, $slug)
	{
		if (Slugs::where([['lang', $lang], ['slug', $slug], ['id', '<>', $id]])->count() > 0) {
			$slug .= "-" . Str::random(4);
		}
		Slugs::updateOrCreate(['id' => $id, 'lang' => $lang], ['slug' => self::createSlugText($slug)]);
	}

	/**
	 * Function : gen meta data
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function gene_meta($metas, $id = 0)
	{
		if (!empty($metas))
			foreach ($metas as $lang => $meta) {
				$slug = $meta['slug'];
				if (Slugs::where([['lang', $lang], ['slug', $slug], ['uid', '<>', "{$meta['module']}-{$meta['method']}-{$id}"]])->count() > 0)
					$slug .= "-" . Str::random(4);

				if (!empty($meta['slug'])) Slugs::updateOrCreate(
					['lang' => $lang, 'uid' => "{$meta['module']}-{$meta['method']}-{$id}"],
					[
						'slug' => self::createSlugText($slug),
						'level' => $meta['level'] ?? null,
						'module' =>  $meta['module'] ?? null,
						'method' =>  $meta['method'] ?? null,
						'data_id' => $id,
						'param' => json_encode($meta['param'] ?? null, JSON_UNESCAPED_UNICODE),
						'meta_auther' =>  $meta['auther'] ?? null,
						'meta_title' => $meta['title'] ?? null,
						'meta_keywords' => $meta['keywords'] ?? null,
						'meta_description' => limit(strip_tags($meta['description'] ?? null), 200),
						'meta_robots' => $meta['robots'] ?? null,
					]
				);
			}
	}

	/**
	 * Function : remove metadata
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function remove_metadata($module, $method, $id)
	{
		Slugs::where([['module', $module], ['method', $method], ['data_id', $id]])->delete();
	}
	public static function routeStatus($module, $method, $id, $status = false)
	{
		try {
			Slugs::where([['module', $module], ['method', $method], ['data_id', $id]])->update(['status' => $status]);
		} catch (\Throwable $th) {
			//throw $th;
		}
	}

	/**
	 * Function : validator slug
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function validatorSlug(Request $request)
	{
		$text[config('app.fallback_locale')] = 'ภาษาไทย!';
		$text['en'] = 'ภาษาอังกฤษ!';

		$metadata = $request->get('meta');
		foreach ($metadata as $lang => $meta) {
			if (empty($meta['slug'])) {
				return ['error' => 0, 'msg' => "โปรดระบุ SEO Slug {$text[$lang]}"];
			}
			$slug = self::createSlugText($meta['slug']);
			$chk_slug = Slugs::where([['lang', $lang], ['slug', $slug], ['uid', '<>', "{$meta['module']}-{$meta['method']}-{$request->get('id')}"]])->first();
			if (!empty($chk_slug)) {
				return ['success' => 0,  'msg' => 'SEO Slug ' . $text[$lang] . ' มีการใช้งานแล้ว'];
			}
		}
	}

	/**
	 * Function :validator slug when update
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public static function validatorSlugUpdate(Request $request)
	{
		$text[config('app.fallback_locale')] = 'ภาษาไทย!';
		$text['en'] = 'ภาษาอังกฤษ!';

		$metadata = $request->get('meta');
		foreach ($metadata as $lang => $meta) {
			if (empty($meta['slug'])) {
				return ['msg' => "โปรดระบุ SEO Slug {$text[$lang]}"];
			}
			$slug = self::createSlugText($meta['slug']);
			$chk_slug = Slugs::where([['lang', $lang], ['slug', $slug], ['uid', '<>', "{$meta['module']}-{$meta['method']}-{$request->get('data_id')}"]])->first();
			if (!empty($chk_slug)) {
				return ['msg' => 'SEO Slug ' . $text[$lang] . ' มีการใช้งานแล้ว'];
			}
		}
	}

	/**
	 * Function : create slug text
	 * Dev : Petch
	 * Update Date : 19 Feb 2025
	 */
	public static function createSlugText($title)
	{
		$title = strip_tags($title);
		// Preserve escaped octets.
		$title = preg_replace('|%([a-fA-F0-9][a-fA-F0-9])|', '---$1---', $title);
		// Remove percent signs that are not part of an octet.
		$title = str_replace('%', '', $title);
		// Restore octets.
		$title = preg_replace('|---([a-fA-F0-9][a-fA-F0-9])---|', '%$1', $title);

		// Remove emojis
		$title = preg_replace('/[\x{1F600}-\x{1F64F}]/u', '', $title); // Emoticons
		$title = preg_replace('/[\x{1F300}-\x{1F5FF}]/u', '', $title); // Misc Symbols and Pictographs
		$title = preg_replace('/[\x{1F680}-\x{1F6FF}]/u', '', $title); // Transport and Map
		$title = preg_replace('/[\x{1F700}-\x{1F77F}]/u', '', $title); // Alchemical Symbols
		$title = preg_replace('/[\x{1F780}-\x{1F7FF}]/u', '', $title); // Geometric Shapes Extended
		$title = preg_replace('/[\x{1F800}-\x{1F8FF}]/u', '', $title); // Supplemental Arrows-C
		$title = preg_replace('/[\x{1F900}-\x{1F9FF}]/u', '', $title); // Supplemental Symbols and Pictographs
		$title = preg_replace('/[\x{1FA00}-\x{1FA6F}]/u', '', $title); // Chess Symbols
		$title = preg_replace('/[\x{1FA70}-\x{1FAFF}]/u', '', $title); // Symbols and Pictographs Extended-A

		if (self::seems_utf8($title)) {
			if (function_exists('mb_strtolower'))
				$title = mb_strtolower($title, 'UTF-8');
			$title = self::utf8_uri_encode($title, 2048);
		}

		$title = strtolower($title);
		$title = preg_replace('/&.+?;/', '', $title); // kill entities
		$title = str_replace('.', '-', $title);
		$title = preg_replace('/[^%a-z0-9 _-]/', '', $title);
		$title = preg_replace('/\s+/', '-', $title);
		$title = preg_replace('|-+|', '-', $title);
		$title = trim($title, '-');

		return urldecode($title);
	}

	/**
	 * Function : seems utf8
	 * Dev : Tong
	 * Update Date : 29 Apr 2024
	 */
	public static function seems_utf8($str)
	{
		$length = strlen($str);
		for ($i = 0; $i < $length; $i++) {
			$c = ord($str[$i]);
			if ($c < 0x80) $n = 0; # 0bbbbbbb
			elseif (($c & 0xE0) == 0xC0) $n = 1; # 110bbbbb
			elseif (($c & 0xF0) == 0xE0) $n = 2; # 1110bbbb
			elseif (($c & 0xF8) == 0xF0) $n = 3; # 11110bbb
			elseif (($c & 0xFC) == 0xF8) $n = 4; # 111110bb
			elseif (($c & 0xFE) == 0xFC) $n = 5; # 1111110b
			else return false; # Does not match any model
			# n bytes matching 10bbbbbb follow ?
			for ($j = 0; $j < $n; $j++)
				if ((++$i == $length) || ((ord($str[$i]) & 0xC0) != 0x80)) return false;
		}
		return true;
	}

	/**
	 * Function : utf8 uri encode
	 * Dev : Tong
	 * Update Date : 29 Apr 2024
	 */
	public static function utf8_uri_encode($utf8_string, $length = 0)
	{
		$unicode = '';
		$values = array();
		$num_octets = 1;
		$unicode_length = 0;

		$string_length = strlen($utf8_string);
		for ($i = 0; $i < $string_length; $i++) {

			$value = ord($utf8_string[$i]);

			if ($value < 128) {
				if ($length && ($unicode_length >= $length))
					break;
				$unicode .= chr($value);
				$unicode_length++;
			} else {
				if (count($values) == 0) $num_octets = ($value < 224) ? 2 : 3;
				$values[] = $value;
				if ($length && ($unicode_length + ($num_octets * 3)) > $length) break;
				if (count($values) == $num_octets) {
					if ($num_octets == 3) {
						$unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]) . '%' . dechex($values[2]);
						$unicode_length += 9;
					} else {
						$unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]);
						$unicode_length += 6;
					}
					$values = array();
					$num_octets = 1;
				}
			}
		}

		return $unicode;
	}

	/**
	 * Function :  get slug
	 * Dev : Tong
	 * Update Date : 19 Sep 2022
	 * @param POST
	 * @return json response update slug
	 */
	public function get_list(Request $request)
	{
		$filter = $request->get('parent');
		$req = new Slugs;
		if (!empty($filter['search'])) {
			$req = $req->where('name', 'like', "%{$filter['search']}%");
		}
		if (!empty($filter['id'])) {
			$req = $req->where('id', '<>', $filter['id']);
		}
		$slugs = $req->where([['type', 1], ['lang', app()->getLocale()]])->orderBy('slug', 'asc')->get();
		$result = [];
		foreach ($slugs as $slug) {
			$result[] = ['id' => $slug->id, 'text' => $slug->slug];
		}
		return self::response(['results' => $result], 200);
	}


	public function getUrlSlug($module, $method, $data_id, $lang)
    {
        $result = [];
        if (!empty($data_id)) {
            $result = '';
            $slug = $this->getSlugUrl($module, $method, $data_id);
            if (!empty($slug['url'])) {
                $result = !empty($slug['url'][$lang]) && $slug['url'][$lang] != "/$lang ?? '' " ? URL::to($slug['url'][$lang]) : '';
            }
        }
        return $result;
    }
}
