<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;
use Modules\Contact\app\Http\Controllers\ContactController;
use Modules\Mwz\app\Http\Controllers\SlugController;
use Modules\Setting\app\Models\Setting;
use Modules\User\app\Http\Controllers\RoleController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Modules\Setting\app\Models\SMTP;
use Phattarachai\LineNotify\Facade\Line;

/**
 * Function : test mwz helper
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function mwz_test()
{
	echo 'test';
}

/**
 * Function : print pre
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function pre($a)
{
	echo '<pre>';
	print_r($a);
	echo '</pre>';
}

/**
 * Function : get text string
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function mwz_getTextString($str, $encode = true)
{
	if ($encode) {
		return htmlspecialchars_decode(html_entity_decode($str));
	}
	return $str;
}

/**
 * Function : set text string
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function mwz_setTextString($str, $encode = false)
{
	if ($encode) {
		return htmlentities(htmlspecialchars($str));
	}
	return $str;
}

/**
 * Function : sanitize UTF-8 string
 * Dev : Assistant
 * Update Date : 1 Sep 2025
 */
function mwz_sanitizeUtf8($str)
{
	if (empty($str)) {
		return $str;
	}
	
	// Check if the string is valid UTF-8
	if (!mb_check_encoding($str, 'UTF-8')) {
		// Try to convert from various encodings
		$encodings = ['ISO-8859-1', 'ISO-8859-15', 'Windows-1252', 'CP1252'];
		foreach ($encodings as $encoding) {
			if (mb_check_encoding($str, $encoding)) {
				$str = mb_convert_encoding($str, 'UTF-8', $encoding);
				break;
			}
		}
	}
	
	// Remove any invalid UTF-8 sequences
	$str = iconv('UTF-8', 'UTF-8//IGNORE', $str);
	
	return trim($str);
}

/**
 * Function : check route
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function route_has($route = '', $txt = 'text')
{
	return (!empty($route) && Route::has($route)) ? route($route) : "#{$txt}";
}

/**
 * Function : check file in server
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function CheckFileInServer($file = null)
{
	if (!empty($file) && file_exists($_SERVER['DOCUMENT_ROOT'] . parse_url($file, PHP_URL_PATH))) {
		return true;
	}
	return false;
}

/**
 * Function : check file return path
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function check_file($file, $thumbnail = null)
{
	if (!empty($file) && file_exists($_SERVER['DOCUMENT_ROOT'] . parse_url($file, PHP_URL_PATH))) {
		return asset($file);
	} else {
		return ($thumbnail ?? asset('assets/images/3-2.png'));
	}
}

/**
 * Function : limit text
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function limit($value, $limit = 100, $end = '...')
{
	return Str::limit($value, $limit, $end);
}

/**
 * Function : mwz check roles
 * Dev : Petch
 * Update Date : 21 Jan 2025
 */
function mwz_roles($permission, $group = null, $id = null)
{
	$role = new RoleController();

	return !empty($group) ? $role->allow($permission, $group, $id) : $role->allow_route($permission, $id);
}

function mwz_slug(...$url)
{
	$path = [];
	if (!empty($url)) {
		foreach ($url as $value) {
			if (!empty($value)) {;
				$path[] = $value;
			}
		}
	}

	if (!empty($path)) {
		return mwz_route('frontend.slug', $path);
	} else {
		return '#';
	}
}

/**
 * Function : set pagination
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function setPagination($page = 1, $totel = 1, $set = 5, $str = '...')
{
	$off = $set - 1;
	$data = [];

	if ($totel <= $set) {
		for ($i = 1; $i <= $totel; $i++)
			array_push($data, $i);
	} else {
		if ($page < $off) {
			for ($i = 1; $i <= $off; $i++) {
				if ($i < $totel) array_push($data, $i);
			}
			array_push($data, $str, $totel);
		} elseif ($page > ($totel - ($set - 2))) {
			array_push($data, 1, $str);
			for ($i = $totel - ($set - 2); $i <= $totel; $i++) {
				if ($i > 1) array_push($data, $i);
			}
		} elseif ($page >= $off && $page <= $totel) {
			array_push($data, 1, $str);
			for ($i = $page - 1; $i <= $page + 1; $i++) {
				if ($i > 1 && $i < $totel) array_push($data, $i);
			}
			array_push($data, $str, $totel);
		}
	}
	return $data;
}

/**
 * Function : mwz route
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function mwz_route(string $route_name, string|array $param = [])
{
	if (!is_array($param)) {
		$param = [$param];
	}
	if (config('app.fallback_locale') == app()->getLocale()) {
		if (!empty($param)) {
			return route($route_name, $param);
		} else {
			return route($route_name);
		}
	} else {
		$param = array_merge([app()->getLocale()], $param);
		if (!empty($param)) {
			return route("lang.{$route_name}", $param);
		} else {
			return route("lang.{$route_name}");
		}
	}
}

/**
 * Function : string format
 * Dev : Petch
 * Update Date : 19 Feb 2025
 */
function str_format($tel, $str = '-', $pattern = [3, 3, 4])
{
	if (empty($tel))
		return null;

	$tel = preg_replace('/[^0-9]/', '', $tel);
	$res = [];
	$last = array_key_last($pattern);

	foreach ($pattern as $i => $value) {
		$res[] = substr($tel, 0, $value);
		$tel = substr($tel, $value);

		if ($last == $i && strlen($tel) > 0)
			$res[] = $tel;
	}

	return implode($str, $res);
}

/**
 * Function : string format date
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function str_date($date, $formate = 'Y-m-d')
{

	if (empty($date)) return null;
	$str = null;
	$m = date("n", strtotime($date));
	$y = date("Y", strtotime($date));
	if (app()->getLocale() == 'th') $y += 543;
	$text = str_split($formate);
	foreach ($text as $item) {
		if (in_array($item, ['d', 'D', 'H', 'h', 'I', 'i', 'S', 's'])) {
			$str .= date($item, strtotime($date));
		} elseif ($item == 'M') {
			$str .= __("admin.month.full.{$m}");
		} elseif ($item == 'm') {
			$str .= __("admin.month.sort.{$m}");
		} elseif ($item == 'Y') {
			$str .= $y;
		} elseif ($item == 'y') {
			$str .= substr($y, 2, 2);
		} else $str .= $item;
	}
	return $str;
}


/**
 * Function : get ip address
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function ip_address()
{
	if (isset($_SERVER['HTTP_CLIENT_IP'])) {
		return $_SERVER['HTTP_CLIENT_IP'];
	} elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		return $_SERVER['HTTP_X_FORWARDED_FOR'];
	} elseif (isset($_SERVER['HTTP_X_FORWARDED'])) {
		return $_SERVER['HTTP_X_FORWARDED'];
	} elseif (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
		return $_SERVER['HTTP_FORWARDED_FOR'];
	} elseif (isset($_SERVER['HTTP_FORWARDED'])) {
		return $_SERVER['HTTP_FORWARDED'];
	} elseif (isset($_SERVER['REMOTE_ADDR'])) {
		return $_SERVER['REMOTE_ADDR'];
	} else {
		return 'UNKNOWN';
	}
}

/**
 * Function : get side menu
 * Dev : Petch
 * Update Date : 21 Jan 2025
 */
function mwz_side_menu()
{
	$list = [];
	if (File::exists('assets/json/menu.json')) {
		$menus = File::json('assets/json/menu.json', JSON_UNESCAPED_UNICODE);
		if (!empty($menus)) {
			foreach ($menus as $item) {
				if (!side_roles($item))
					continue;

				$list[] = side_menu($item);
			}
		}
	}
	return $list;
}

/**
 * Function : get side menu
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function side_menu($row)
{
	$data = menu_data($row);
	if (!empty($row['child']) && count($row['child']) > 0) {
		foreach ($row['child'] as $item) {
			if (!side_roles($item)) {
				continue;
			}
			$data['side'][] = side_menu($item);
		}
	}
	return $data;
}

/**
 * Function : mendu data
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function menu_data($row)
{
	return array(
		'id' => $row['id'] ?? 0,
		'name' => $row['name'] ?? '',
		'icon' => $row['icon'] ?? null,
		'route' => $row['permission']['route_name'] ?? '',
		'status' => mwz_roles($row['permission']['route_name'] ?? ''),
		'parent_id' => $row['parent_id'] ?? ''
	);
}

/**
 * Function : side_roles
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function side_roles($req)
{
	if (!empty($req['child']) && count($req['child']) > 0) {
		foreach ($req['child'] as $item) {
			if (side_roles($item) == true)
				return true;
		}
	} elseif (!empty($req['permission']['route_name']) && mwz_roles($req['permission']['route_name']))
		return true;

	return false;
}

/**
 * Function : set flat category
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function mwz_setFlatCategory($categories)
{
	$traverse = function ($categories, $prefix = '-', $level = 0, &$result = []) use (&$traverse) {
		foreach ($categories as  $category) {
			$category->level = $level;
			if ($level > 0) {
				$show_prefix = str_pad('', $level, $prefix);
				$category->title =  $show_prefix . ' ' . $category->title;
			}
			if (!empty($category->children)) {
				$new_category = $category;
				unset($new_category->children);
				$result[$category->category_id] = $new_category;
				$traverse($category->children, '-', $level + 1, $result);
			} else {
				$result[$category->category_id] = $category;
			}
		}
		return $result;
	};

	return $traverse($categories);
}

/**
 * Function : seting 
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function setting()
{
	try {
		$data = Setting::find(1);
		if (!empty($data)) {
			return $data;
		}
	} catch (\Throwable $th) {
	}
}

/**
 * Function : meta
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function meta()
{
	try {
		return SlugController::meta_data_locale('index', 'index', 1);
	} catch (\Throwable $th) {
	}
}

/**
 * Function : contact
 * Dev : Tong
 * Update Date : 29 Apr 2024
 */
function contact()
{
	$req = new ContactController;
	return $req->sort_contact();
}

/**
 * Function : random string default 10
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function srt_random($length = 10)
{
	return Str::random($length);
}


/**
 * Function : currency
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function currency($curr = null)
{
	$list = [
		'thb' => __('admin.currency.thb'),
		'usd' => __('admin.currency.usd'),
	];
	if (!empty($curr)) {
		return $list[$curr] ?? '';
	} else {
		return $list;
	}
}

/**
 * Function : order string
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function orderno($item, $unit = 7,  $prefix = '', $str = '')
{
	return $prefix . date('y') . date('W') . str_pad(($item + 1), $unit, '0', STR_PAD_LEFT) . $str;
}

/**
 * Function : str implode
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function str_implode($str = ', ', ...$params)
{
	$text = [];
	if (!empty($params)) {
		foreach ($params as $item) {
			if (!empty($item)) {
				if (is_array($item)) {
					foreach ($item as $val) {
						if (!empty($val)) {
							$text[] = $val;
						}
					}
				} else {
					$text[] = $item;
				}
			}
		}
	}
	return implode($str, $text);
}
/**
 * Function : date range
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function date_range($txt, $start, $end)
{
	$fmt = ['d'];
	if (date("n", strtotime($start)) != date("n", strtotime($end))) {
		$fmt[] = 'm';
	}
	if (date("y", strtotime($start)) != date("y", strtotime($end))) {
		$fmt[] = 'Y';
	}
	return str_implode($txt, str_date($start, implode(' ', $fmt)), str_date($end, 'd m Y'));
}

/**
 * Function : check file upload
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function check_file_upload(Request $request, string $name, array|string $accept = 'image')
{
	if ($request->hasFile($name)) {
		$file = $request->file($name);
		//favicon
		if ($accept == 'favicon') {
			if (!in_array($file->getMimeType(), mime_type($accept))) 
				return true; // Return true for error (invalid file type)
		}else{
			if ($file->getClientMimeType() !== $file->getMimeType() && !in_array($file->getMimeType(), mime_type($accept)))
				return true;
		}
	}
	return false;
}

/**
 * Function : check file upload
 * Dev : Wan
 * Update Date : 10 Apr 2025
 */
function check_file_upload_multiple(Request $request, string $name, array|string $accept = 'image')
{
	if ($request->hasFile($name)) {
		$files = $request->file($name);
		if (!is_array($files)) {
			$files = [$files];
		}

		foreach ($files as $file) {
			if ($file->getClientMimeType() !== $file->getMimeType() || !in_array($file->getMimeType(), mime_type($accept))) {
				return true;
			}
		}
	}

	return false;
}

/**
 * Function : check type image
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function mime_type(array|string $accept = 'image'): array
{
	$types = (is_array($accept)) ? $accept : [$accept];
	$resp = [];
	foreach ($types as $type) {
		switch ($type) {
			case 'image':
				// ไม่อนุญาตให้อัปโหลดไฟล์ ให้ upload แค่รูป
				$resp = array_merge($resp, [
					'image/apng', 'image/avif', 'image/gif', 'image/jpeg', 'image/jpg', 'image/png', 'image/webp'
				]);
				break;
			case 'favicon':
				$resp = array_merge($resp, config('upload.allowed_image_types', [
					'image/apng', 'image/avif', 'image/gif', 'image/jpeg', 'image/png', 'image/webp','image/x-icon','image/vnd.microsoft.icon','image/svg+xml'
				]));
				break;
			case 'audio':
				$resp = array_merge($resp, config('upload.allowed_audio_types', [
					'audio/mpeg', 'audio/mp4', 'audio/aac', 'audio/rtp-midi'
				]));
				break;
			case 'video':
				$resp = array_merge($resp, config('upload.allowed_video_types', [
					'video/h264', 'video/mp4', 'video/quicktime', 'video/raw'
				]));
				break;
			case 'file':
				$resp = array_merge($resp, config('upload.allowed_document_types', [
					'text/plain',
					'text/csv',
					'application/pdf',
					'application/zip',
					'application/x-csv',
					'application/msword',
					'application/vnd.ms-excel',
					'application/vnd.ms-powerpoint',
					'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
					'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
					'application/vnd.openxmlformats-officedocument.presentationml.presentation'
				]));
				break;
		}
	}
	return $resp;
}

/**
 * Function : check file size
 * Dev : Poom
 * Update Date : 10 Apr 2025
 */
function check_file_size($file, $max_size = null)
{
	if (!$max_size) {
		$max_size = config('upload.max_file_size', '2M');
	}
	
	// Convert max_size to bytes
	$max_bytes = convert_size_to_bytes($max_size);
	
	return $file->getSize() <= $max_bytes;
}

/**
 * Function : convert size string to bytes
 * Dev : Poom
 * Update Date : 10 Apr 2025
 */
function convert_size_to_bytes($size_string)
{
	$size_string = strtolower(trim($size_string));
	
	if (preg_match('/^(\d+)([kmg])?$/', $size_string, $matches)) {
		$size = (int) $matches[1];
		$unit = $matches[2] ?? '';
		
		switch ($unit) {
			case 'k':
				return $size * 1024;
			case 'm':
				return $size * 1024 * 1024;
			case 'g':
				return $size * 1024 * 1024 * 1024;
			default:
				return $size;
		}
	}
	
	return 0;
}

/**
 * Function : get languages
 * Dev : Poom
 * Update Date : 29 Apr 2024
 */
function languages()
{
	$lang = [];
	if (File::exists("assets/json/languages.json"))
		$lang = File::json("assets/json/languages.json");

	if (empty($lang)) {
		$lang['en'] = ["flag" => "flag flag-en", "name" => "English"];
		$lang['th'] = ["flag" => "flag flag-th", "name" => "ภาษาไทย"];
	}
	return $lang;
}
/**
 * Function : send line notify
 * Dev : Petch
 * Update Date : 19 Apr 2024
 * @param string $msg
 * @return bool
 */
function send_line_noti($msg): bool
{
	try {
		$smtp = SMTP::find(1);
		$line_token = $smtp->line_token ?? null;

		if (!empty($line_token))
			Line::setToken($line_token)->send($msg ?? 'test line notify');

		return true;
	} catch (\Throwable $th) {
		return false;
	}
}

/**
 * Function : set config mail
 * Dev : Petch
 * Update Date : 19 Apr 2024
 * @return bool
 */
function config_mail(): bool
{
	try {
		$smtp = SMTP::find(1);
		if (!empty($noti)) {
			config(['mail.mailers.smtp.host' => $smtp->email_host]);
			config(['mail.mailers.smtp.port' => $smtp->email_port]);
			config(['mail.mailers.smtp.username' => $smtp->email_username]);
			config(['mail.mailers.smtp.password' => $smtp->email_password]);
			config(['mail.mailers.smtp.encryption' => $smtp->email_encryption]);
			config(['mail.from.address' => $smtp->email_address]);
			config(['mail.from.name' => $smtp->email_name]);
			return true;
		}
		return false;
	} catch (\Throwable $th) {
		return false;
	}
}

function encode($data, $prefix = '', $suffix = '')
{
	return base64_encode($prefix . $data . $suffix);
}

function decode($data, $prefix = '', $suffix = '')
{
	$decode = base64_decode($data);
	// Remove the prefix and suffix
	if ($prefix && strpos($decode, $prefix) === 0) {
		$decode = substr($decode, strlen($prefix));
	}
	if ($suffix && substr($decode, -strlen($suffix)) === $suffix) {
		$decode = substr($decode, 0, -strlen($suffix));
	}
	return $decode;
}

function customize_url($query = '')
{
	$url = '';
	$url = config('app.URL_CUSTOMIZE');
	if (!empty($query)) {
		$url = $url . '?' . $query;
	}
	return $url;
}

function str_code($str = null)
{
	if (empty($str)) return null;
	$str = str_replace(' ', '_', strtolower($str));
	return $str;
}

/**
 * Function : check string contains
 * Dev : Petch
 * Update Date : 24 Jan 2025
 */
function str_containsa(string $haystack, array $needles)
{
	foreach ($needles as $needle) {
		if (str_contains($haystack, $needle))
			return true;
	}

	return false;
}

/**
 * Function : config email
 * Dev : Petch
 * Update Date : 20 Feb 2025
 */
function config_email()
{
	return [
		'content' => [
			'max_width' => 600,
		],
		'logo' => [
			'height' => 30,
		],
		'table_body' => [
			'status' => true,
			'margin_bottom' => 40,
			'padding_bottom' => 0,
			'td_padding_y' => 5,
		],
		'table_table' => [
			'status' => false,
			'margin_bottom' => 40,
			'padding_bottom' => 0,
			'th_padding_y' => 10,
			'td_padding_y' => 10,
		],
		'table_footer' => [
			'status' => false,
			'work' => true,
			'office' => true,
		],
	];
}

function mwz_roles_old($permission, $group = '')
{
	$role = new RoleController();
	switch ($group) {
		case "view":
		case "add":
		case "edit":
		case "delete":
			return $role->allow($permission, $group);
			break;
		default:
			return $role->allow_route($permission);
			break;
	}
}

/**
 * Function : config email
 * Dev : Wan
 * Update Date : 14 Aug 2025
 */
function wrapHeadInScript($headContent)
{
    // ถ้ามี <script> แล้ว → ไม่ต้องทำอะไร
    if (stripos($headContent, '<script') !== false) {
        return $headContent;
    }

    // ไม่มี script → wrap ข้อความไว้ใน <script>...</script>
    return '<script>' . $headContent . '</script>';
}

