<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => 'admin', 'middleware' => ['auth:admin', 'adminAccessControl']], function () {
	// ============================== menu admin ============================== //
	Route::prefix('menu')->group(function () {
		Route::prefix('group')->group(function () {
			Route::get('/', 'GroupMenuAdminController@index')->name('admin.menu.group.index');
			Route::get('/datatable_ajax', 'GroupMenuAdminController@datatable_ajax')->name('admin.menu.group.datatable_ajax');

			Route::get('/add', 'GroupMenuAdminController@form')->name('admin.menu.group.add');
			Route::get('/edit/{id?}', 'GroupMenuAdminController@form')->name('admin.menu.group.edit');
			Route::get('/view/{id?}', 'GroupMenuAdminController@form')->name('admin.menu.group.view');
			Route::post('/save', 'GroupMenuAdminController@save')->name('admin.menu.group.save');

			Route::post('/set_sort', 'GroupMenuAdminController@set_sort')->name('admin.menu.group.set_sort');
			Route::post('/set_status', 'GroupMenuAdminController@set_status')->name('admin.menu.group.set_status');
			Route::post('/set_delete', 'GroupMenuAdminController@set_delete')->name('admin.menu.group.set_delete');

			Route::post('/get_list', 'GroupMenuAdminController@get_list')->name('admin.menu.group.get_list');
		});

		Route::prefix('/menu/{group}')->group(function () {
			Route::get('/', 'MenuAdminController@index')->name('admin.menu.menu.index');
			Route::get('/datatable_ajax', 'MenuAdminController@datatable_ajax')->name('admin.menu.menu.datatable_ajax');

			Route::get('/add', 'MenuAdminController@form')->name('admin.menu.menu.add');
			Route::get('/edit/{id?}', 'MenuAdminController@form')->name('admin.menu.menu.edit');
			Route::get('/view/{id?}', 'MenuAdminController@form')->name('admin.menu.menu.view');
			Route::post('/save', 'MenuAdminController@save')->name('admin.menu.menu.save');

			Route::get('/tree', 'MenuAdminController@tree')->name('admin.menu.menu.tree');
			Route::post('/tree/sort', 'MenuAdminController@tree_sort')->name('admin.menu.menu.tree_sort');

			Route::post('/set_sort', 'MenuAdminController@set_sort')->name('admin.menu.menu.set_sort');
			Route::post('/set_status', 'MenuAdminController@set_status')->name('admin.menu.menu.set_status');
			Route::post('/set_delete', 'MenuAdminController@set_delete')->name('admin.menu.menu.set_delete');

			Route::post('/get_list', 'MenuAdminController@get_list')->name('admin.menu.menu.get_list');
		});
	});
});
