@if (!empty($setting['type']['status']))
    <div class="card card-body">
        <div class="row">
            @if (!empty($setting['type']['status']))
                <?php $disabled = !empty($data->id) ? 'true' : 'false'; ?>
                <div class="mb-2 col-lg-3">
                    <x-select2.selection class="select2" id="type" name="type" label="{{ __('field.type') }}"
                        required="{{ $setting['type']['validate'] ?? false }}"
                        placeholder="{{ __('field.type_placeholder') }}" :disabled=$disabled>
                        @slot('option')
                            @if (!empty($config['types']))
                                @foreach ($config['types'] as $t => $name)
                                    <option value="{{ $t }}" @if (($data->type ?? 1) == $t) selected @endif>
                                        {{ $name }} </option>
                                @endforeach
                            @endif
                        @endslot
                    </x-select2.selection>
                </div>
                @if (!empty($disabled) and !empty($data->id))
                    <input type="hidden" name="type" value="{{ $data->type ?? 1 }}">
                @endif
            @endif
            @if (!empty($setting['slug']['status']))
                <div class="mb-2 col-lg select-type" data-id="1">
                    @php
                        $s = $data->slug ?? null;
                        $selected = !empty($s) ? ['id' => $s->uid, 'text' => $s->slug] : null;
                    @endphp
                    <x-select2.select id="slug_id" name="slug_id" label="{{ __('field.slug') }}" :selected=$selected
                        url="/admin/slug/get_list" placeholder="{{ __('field.slug_placeholder') }}"
                        required="{{ $setting['slug']['validate'] ?? false }}" :map=false :disabled=$disabled />
                </div>
            @endif
            @if (!empty($setting['url']['status']))
                <div class="mb-2 col-lg select-type" data-id="2">
                    <x-form.input name="url" type="input" value="{{ $data->url ?? null }}"
                        label="{{ __('field.url') }}" required="{{ $setting['url']['validate'] ?? false }}"
                        placeholder="{{ __('field.url_placeholder') }}" />
                </div>
            @endif
            @if (!empty($setting['tag']['status']))
                <div class="mb-2 col-lgl-3">
                    <x-form.input name="tag" type="input" value="{{ $data->tag ?? null }}"
                        label="{{ __('field.tag') }}" required = "{{ $config['tag']['validate'] ?? false }}"
                        placeholder="{{ __('field.tag_placeholder') }}" />
                </div>
            @endif
        </div>
    </div>
@endif
