@extends('form.app')

@section('styles')
@endsection

@section('content')
    {{-- navbar --}}
    @includeIf('menu::menu.form.navbar')
    <?php $input = $config['input'] ?? null; ?>
    <?php $setting = $config['setting'] ?? null; ?>
    <form class="row" id="menu_frm" name="menu_frm" method="POST" enctype="multipart/form-data">
        @csrf
        <input id="id" name="id" type="hidden" value="{{ $data->id ?? '0' }}">
        <input id="group_id" name="group_id" type="hidden" value="{{ $group_id ?? 0 }}">
        <div class="col-lg-9">
            @includeIf('menu::menu.form.translates')
            @includeIf('menu::menu.form.setting')
        </div>
        <div class="col-lg-3">
            <x-form.lang />
            @includeIf('menu::menu.form.parent')
            @includeIf('menu::menu.form.status')
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        var $_group_id = "<?= $root_id ?? 0 ?>";
        var $_config = $.parseJSON('<?= json_encode($config) ?>');
    </script>
    {{ module_vite('build-menu', 'resources/assets/js/menu.js') }}
@endsection
