$(document).ready(function () {
	initDatatable();
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	if ($("#group-datatable").length > 0) {
		$("#group-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: `/admin/menu/group/datatable_ajax`,
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: [
				{ data: "DT_RowIndex", className: 'text-center' },
				{ data: "name", orderable: false },
				{ data: "updated_at", orderable: true },
				{ data: "action", orderable: false, className: 'text-center' }
			],
			language: $_LANG.datatable,
		})
		init_Table();
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	($("#group-datatable").length > 0) &&
		$("#group-datatable").DataTable().ajax.reload(null, bool);
}
/**
* Function : Set Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setStatus = function (id) {
	event.preventDefault();
	$.ajax({
		url: `/admin/menu/group/set_status`,
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	})
}
/**
* Function : Delete data by id
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
	event.preventDefault();
	$.ajax({
		url: `/admin/menu/group/set_delete`,
		type: "POST",
		data: { id: id, },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};
/**
* Function : Sort Item
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSort = function (id, move) {
	event.preventDefault();
	$.ajax({
		url: `/admin/menu/group/set_sort`,
		type: "POST",
		data: { id: id, move: move },
		headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};
/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();

	var frm = $("#menu_frm");
	var frm_data = new FormData($(frm)[0]);
	$.ajax({
		url: `/admin/menu/group/save`,
		type: "POST",
		data: frm_data,
		contentType: false,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
		beforeSend: function (xhr) {
			// validate
			var rules = [], msg = [];
			$.each($_lang, function (i, lang) {
				$.each($_config.input, function (key, ele) {
					switch (key) {
						case 'name':
						case 'desc':
							rules[`${key}_${lang}`] = (key == "name") ? { required: ele.validate && ele.status, maxlength: 255 } : { required: ele.validate && ele.status };
							msg[`${key}_${lang}`] = { required: $(frm).find(`[name="${key}_${lang}"]`).attr('placeholder') };
							break;
					}
				});
			});


			mwz_validate($(frm), rules, msg);
			return frm_valid($(frm));
		},
		success: function (resp) {
			mwz_noti("success", resp.msg, window.location.replace(`/admin/menu/group`));
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};
/**
* Function : select type
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.$('#type').change(function () {
	var type = $(this).val();
	if ($('.select-type').length > 0) {
		$('.select-type').hide();
		$('.select-type').each(function () {
			if (type == $(this).data('id')) { $(this).show(); }
		})
	}
})