@extends('table.app')

@section('styles')
    <!-- datatable re order -->
    <link href="{{ asset('assets/libs/datatable-reorder/rowReorder.dataTables.min.css') }}" rel="stylesheet" />
@endsection

@section('content')
    <!-- table -->
    @includeIf('member::table.table')
    <!-- table -->

    <!-- filter -->
    @includeIf('member::table.filter')
    <!-- filter -->

    <!-- Import Modal -->
    <div class="modal fade" id="importModal" tabindex="-1" role="dialog" aria-labelledby="importModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="importModalLabel">
                        <i class="mdi mdi-file-import-outline me-1"></i>
                        นำเข้าข้อมูลสมาชิก
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">เลือกไฟล์ที่ต้องการนำเข้า</label>
                        <input type="file" class="form-control" id="importFile" accept=".xlsx,.xls,.csv">
                        <small class="text-muted">รองรับไฟล์: .xlsx, .xls, .csv (ขนาดไม่เกิน 10MB)</small>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="mdi mdi-information-outline me-1"></i>
                        <strong>คำแนะนำ:</strong>
                        <ul class="mb-0 mt-2">
                            <li>ดาวน์โหลดไฟล์ template ด้านล่างเพื่อดูรูปแบบที่ถูกต้อง</li>
                            <li>ไฟล์ต้องมีหัวคอลัมน์: <strong>name, email, department, position</strong></li>
                            <li><strong class="text-danger">ชื่อและอีเมลเป็นข้อมูลที่จำเป็นต้องกรอก</strong></li>
                            <li>ถ้ามี email ซ้ำกับข้อมูลเดิม ระบบจะอัพเดทข้อมูลนั้น</li>
                        </ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="downloadTemplate()">
                        <i class="mdi mdi-download me-1"></i> ดาวน์โหลด Template
                    </button>
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">ยกเลิก</button>
                    <button type="button" class="btn btn-primary" id="importBtn" onclick="handleImportUpload()">
                        <i class="mdi mdi-file-import-outline me-1"></i> นำเข้าข้อมูล
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Export Modal -->
    <div class="modal fade" id="exportModal" tabindex="-1" role="dialog" aria-labelledby="exportModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exportModalLabel">
                        <i class="mdi mdi-file-export-outline me-1"></i>
                        ส่งออกข้อมูลสมาชิก
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info mb-3">
                        <i class="mdi mdi-information-outline me-1"></i>
                        <strong>เลือกรูปแบบไฟล์ที่ต้องการส่งออก</strong>
                    </div>
                    <div class="row">
                        <div class="col-12 mb-3">
                            <div class="card export-option" onclick="selectExportFormat('excel')" style="cursor: pointer; border: 2px solid transparent;">
                                <div class="card-body text-center">
                                    <i class="mdi mdi-file-excel-outline" style="font-size: 48px; color: #217346;"></i>
                                    <h5 class="mt-2">Excel (.xlsx)</h5>
                                    <p class="text-muted mb-0">เหมาะสำหรับการวิเคราะห์และแก้ไขข้อมูล</p>
                                </div>
                            </div>
                        </div>
                        @if (!empty($config['table']['btn']['pdf']))
                            <div class="col-12 mb-3">
                                <div class="card export-option" onclick="selectExportFormat('pdf')" style="cursor: pointer; border: 2px solid transparent;">
                                    <div class="card-body text-center">
                                        <i class="mdi mdi-file-pdf-box" style="font-size: 48px; color: #d32f2f;"></i>
                                        <h5 class="mt-2">PDF (.pdf)</h5>
                                        <p class="text-muted mb-0">เหมาะสำหรับการพิมพ์และเก็บเป็นเอกสาร</p>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">ยกเลิก</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="{{ asset('assets/libs/datatable-reorder/dataTables.rowReorder.min.js') }}"></script>

    <script>
        const $_name = '<?= $method ?>';
        const $_type = '<?= $type ?>';
        const $_config = $.parseJSON('<?= json_encode($config) ?>');

        // link action
        const $_link_datatable = '{{ route("admin.{$type}.{$method}.datatable_ajax") }}';
        const $_link_sort = '{{ route("admin.{$type}.{$method}.set_sort") }}';
        const $_link_default = '{{ route("admin.{$type}.{$method}.set_default") }}';
        const $_link_status = '{{ route("admin.{$type}.{$method}.set_status") }}';
        const $_link_delete = '{{ route("admin.{$type}.{$method}.set_delete") }}';
        const $_link_send_email = '{{ route("admin.{$type}.{$method}.send_email", ["id" => ":id"]) }}';
        const $_link_export = '{{ route("admin.{$type}.{$method}.export") }}';
        const $_link_import = '{{ route("admin.{$type}.{$method}.import") }}';
        const $_link_download_template = '{{ route("admin.{$type}.{$method}.download_template") }}';
    </script>

    {{ module_vite("build-member", "resources/assets/js/{$method}.js") }}
@endsection
