@extends('form.app')

@section('styles')
    <link href="{{ asset('assets/libs/dropzone/dropzone.min.css') }}" rel="stylesheet" />
@endsection

@section('content')
    {{-- navbar --}}
    @includeIf('member::form.navbar')

    <form class="row" id="{{ $method }}_frm" method="POST" enctype="multipart/form-data">
        @csrf
        <input id="id" name="id" type="hidden" value="{{ $data->id ?? '0' }}">
        <div class="col-lg-9">
            <div class="tab-content">
                @php
                    $active = -1;
                @endphp
                @foreach ($config['form']['navbar'] as $k_n => $n)
                    @if (!empty($n['status']))
                        <div class="tab-pane {{ ++$active == 0 ? 'active' : '' }}" id="{{ $k_n }}">
                            @includeIf("member::form.{$k_n}")
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
        <div class="col-lg-3">
            @if (!empty($config['form']['sidebar']))
                @foreach ($config['form']['sidebar'] as $k_s => $s)
                    @if (!empty($s['status']))
                        @include("member::form.{$k_s}")
                    @endif
                @endforeach
            @endif
        </div>
    </form>
@endsection

@section('scripts')
    <!-- File uploads multiple js -->
    <script src="{{ asset('assets/libs/dropzone/dropzone.min.js') }}"></script>
    <script type="text/javascript">
        Dropzone.autoDiscover = false;
    </script>

    <!-- Jquery UI-->
    <script src="{{ asset('assets/libs/jquery-ui/jquery-ui.min.js') }}"></script>

    <script>
        const $_name = '<?= $method ?>';
        const $_type = '<?= $type ?>';
        const $_config = $.parseJSON('<?= json_encode($config) ?>');

        // link action
        const $_link_save = '{{ route("admin.{$type}.{$method}.save") }}';
    </script>

    {{ module_vite("build-member", "resources/assets/js/{$method}.js") }}
@endsection
