<div class="lang-content" data-lang="{{ $lang ?? config('member.field_settings.default_lang') }}">
    <div class="alert alert-light bg-light text-dark border-0" role="alert">
        <i class="fe-bell me-1"></i>
        {{ __('field.frm') }}
        <strong class="ms-1">{{ $item['name'] ?? '' }}
            <i class="{{ $item['flag'] ?? "flag flag-{$lang}" }}"></i>
        </strong>
    </div>
    <?php $i = 0; ?>
    @foreach ($inputs as $k => $v)
        @if (!empty($v['status']))
            @if ($i % 2 == 0)
                <div class="row">
            @endif
            <?php
            $editableFields = config('member.field_settings.editable_fields', ['department', 'position']);
            $passwordFields = config('member.field_settings.password_fields', ['password', 'confirm_password']);
            $passwordMask = config('member.field_settings.password_mask', '********');
            $fieldType = $v['type'] ?? 'input';
            $isEmailField = $k == 'email' || in_array($fieldType, ['email', 'mail']);
            if (!in_array($k, $editableFields) && !empty($data->id) && $method != 'lavel' && $k != 'name' && !$isEmailField) {
                $readonly = true;
            } else {
                $readonly = false;
            }
            if (in_array($k, $passwordFields)) {
                $value = $passwordMask;
            } else {
                // Get field value as plain string
                $value = $data->{$k} ?? '';
            }
            ?>
            <div class="col-sm-6">
                <div class="mb-2 position-relative">
                    @if (in_array($k, $passwordFields))
                        <x-form.input name="{{ $k ?? '' }}" :type="'pass'" :value="$value ?? null"
                            lang="{{ $lang }}" label="{{ $v['label'] ?? __('field.' . $k) }}"
                            required="{{ $v['validate'] ?? false }}" placeholder='{{ __("field.{$k}_placeholder") }}'
                            :readonly="!empty($readonly)" id="input_{{ $k }}_{{ $lang }}" />
                        <button type="button" class="btn btn-sm position-absolute top-70 end-0 translate-middle-y me-2"
                            style="z-index:3;"
                            onclick="togglePasswordVisibility('input_{{ $k }}_{{ $lang }}', this)">
                            <i class="fe-eye"></i>
                        </button>
                    @else
                        <?php
                        // ตรวจสอบว่าฟิลด์นี้ควรจำกัดเฉพาะตัวเลขและตัวอักษรหรือไม่
                        // ไม่ใช้กับ email, tel, password, date, color, textarea
                        $fieldType = $v['type'] ?? 'input';
                        $excludedTypes = config('member.field_settings.excluded_alphanumeric_types', ['mail', 'email', 'tel', 'date', 'color', 'text', 'texteditor', 'pass']);
                        $isAlphanumericOnly = !in_array($fieldType, $excludedTypes) && empty($readonly);
                        
                        // allow empty for optional fields
                        $optionalFields = config('member.field_settings.optional_fields', ['name']);
                        $isOptionalField = in_array($k, $optionalFields);
                        ?>
                        <x-form.input name="{{ $k ?? '' }}" type="{{ $v['type'] ?? 'input' }}"
                            value="{{ $value ?? null }}" lang="{{ $lang }}"
                            label="{{ $v['label'] ?? __('field.' . $k) }}" :required="!$isOptionalField && ($v['validate'] ?? false)"
                            placeholder='{{ __("field.{$k}_placeholder") }}' :readonly="!empty($readonly)"
                            id="input_{{ $k }}_{{ $lang }}" />
                        @if ($isAlphanumericOnly)
                            <script>
                                // Mark input for alphanumeric validation (will be initialized by member.js)
                                (function() {
                                    const inputId = 'input_{{ $k }}_{{ $lang }}';
                                    if (document.readyState === 'loading') {
                                        document.addEventListener('DOMContentLoaded', function() {
                                            const input = document.getElementById(inputId);
                                            if (input) input.setAttribute('data-alphanumeric', 'true');
                                        });
                                    } else {
                                        const input = document.getElementById(inputId);
                                        if (input) input.setAttribute('data-alphanumeric', 'true');
                                    }
                                })();
                            </script>
                        @endif
                    @endif
                </div>
            </div>
            @if ($i % 2 == 1 || $loop->last)
</div>
@endif
<?php $i++; ?>
@endif
@endforeach
</div>
