<div class="card card-body">
    <div id="form-container">
        @foreach (languages() as $code => $item)
            <?php
            $lang = $code;
            $item = $item;
            $param = $data->langs[$code] ?? '';
            $inputs = $n['input'];
            ?>
            <div class="lang-content form-wrapper border border-solid p-3 m-3" data-lang="{{ $lang ?? 'th' }}">
                <div class="alert alert-light bg-light text-dark border-0" role="alert">
                    <i class="fe-bell me-1"></i>
                    {{ __('field.frm') }}
                    <strong class="ms-1">{{ $item['name'] ?? '' }}
                        <i class="{{ $item['flag'] ?? "flag flag-{$lang}" }}"></i>
                    </strong>
                </div>
                @foreach ($inputs as $k => $v)
                    @if (!empty($v['status']))
                        <div class="mb-2">
                            <x-form.input name="{{ $k }}[]" id="{{ $k }}"
                                type="{{ $v['type'] ?? 'input' }}" value="{{ $param->{$k} ?? null }}"
                                lang="{{ $lang }}" label='{{ __("field.$k") }}'
                                required="{{ $v['validate'] ?? false }}"
                                placeholder='{{ __("field.{$k}_placeholder") }}' />
                        </div>
                    @endif
                @endforeach
            </div>
        @endforeach
    </div>
    @if (!empty($n['multiple']))
        <div class="text-end mt-3">
            <button type="button" class="btn btn-primary" id="add-form-btn">
                <i class="fe-plus me-1"></i> {{ __('field.add_form') }}
            </button>
        </div>
    @endif
</div>
<script>
    let formCount = 1;
    document.getElementById('add-form-btn').addEventListener('click', function() {
        const container = document.getElementById('form-container');
        const originalForms = container.querySelectorAll('.form-wrapper');
        const newWrapper = document.createElement('div');

        originalForms.forEach(originalForm => {
            const clone = originalForm.cloneNode(true);
            formCount++;

            const inputs = clone.querySelectorAll('input, textarea, select');
            inputs.forEach(input => {
                if (input.name) {
                    const originalName = input.name.split('_')[0]; // ตัดชื่อให้เหลือชื่อหลัก
                    input.name = `${originalName}_${formCount}`;
                }
                input.value = '';
            });

            // เพิ่มปุ่มลบเข้าไปใน clone
            const removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'btn btn-danger btn-sm remove-form-btn float-end mt-2';
            removeBtn.innerHTML =
            `<i class="fe-trash"></i>`;
            removeBtn.addEventListener('click', function() {
                clone.remove();
            });

            clone.appendChild(removeBtn);
            newWrapper.appendChild(clone);
        });

        container.appendChild(newWrapper);
    });
</script>
