

$(document).ready(function () {
	
	initDatatable();
	
	// Toggle check_in_out_period field based on period value
	toggleCheckInOutPeriod();
	
	// Listen for period changes
	$(document).on('change', '#period', function() {
		toggleCheckInOutPeriod();
	});
})

/**
 * Enable/disable check_in_out_period field based on period value
 * Only enable when period is "7" (custom/กำหนดเอง)
 */
function toggleCheckInOutPeriod() {
	const periodValue = $('#period').val();
	const checkInOutPeriodInput = $('#check_in_out_period');
	const checkInOutPeriodContainer = checkInOutPeriodInput.closest('.col-lg-3, .col-md-6');
	
	if (checkInOutPeriodInput.length > 0) {
		if (periodValue === '7') {
			// Enable the field
			checkInOutPeriodInput.prop('disabled', false);
			checkInOutPeriodInput.removeClass('disabled');
			if (checkInOutPeriodContainer.length > 0) {
				checkInOutPeriodContainer.css('opacity', '1');
			}
			
			// Enable flatpickr if it exists
			if (checkInOutPeriodInput[0]._flatpickr) {
				checkInOutPeriodInput[0]._flatpickr.config.disabled = false;
			}
		} else {
			// Check if there was a value before clearing (to avoid unnecessary reload)
			const hadValue = checkInOutPeriodInput.val() !== '' && checkInOutPeriodInput.val() !== null;
			
			// Disable the field and clear value
			checkInOutPeriodInput.prop('disabled', true);
			checkInOutPeriodInput.addClass('disabled');
			if (checkInOutPeriodContainer.length > 0) {
				checkInOutPeriodContainer.css('opacity', '0.6');
			}
			
			// Clear flatpickr value if it exists
			if (checkInOutPeriodInput[0]._flatpickr) {
				checkInOutPeriodInput[0]._flatpickr.clear();
				checkInOutPeriodInput[0]._flatpickr.config.disabled = true;
			} else {
				checkInOutPeriodInput.val('');
			}
			
			// Trigger change to reload datatable only if there was a value that was cleared
			if (hadValue && typeof setReloadDataTable === 'function') {
				setReloadDataTable(true);
			}
		}
	}
}

window.__timelineFilters = {};

function collectTimelineFilters() {
	const payload = {};
	$('.frm-filter').each(function () {
		const name = this.name;
		if (!name || name === '_token') return;

		const value = $(this).val();
		if (Array.isArray(value)) {
			payload[name] = value.filter(v => v !== undefined && v !== null && v !== '');
		} else {
			payload[name] = value ?? '';
		}
	});
	return payload;
}

window.initDatatable = function () {
	if ($(`#${$_name}-datatable`).length > 0) {
		let column = [{ data: "DT_RowIndex", className: 'text-center' }];

		$_config.table.header.forEach((e) => {
			if (e.status)
				column.push({ data: e.column, orderable: e.orderable, className: e.class ?? '' });
		});
		($_config.table.btn.sort) && column.push({ data: "sort", orderable: false, className: 'text-center' });
		column.push(
			{ data: "updated_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		);

		let cfg = {
			processing: true,
			serverSide: true,
			stateSave: true,
			columnDefs: [
				{ orderable: true, className: "reorder", targets: 0 },
				{ orderable: false, targets: "_all" },
			],
			ajax: {
				url: $_link_datatable,
				data: function (d) {
					const payload = collectTimelineFilters();
					console.log('datatable payload', payload);
					Object.entries(payload).forEach(function ([name, value]) {
						d[name] = value;
					});
					window.__timelineFilters = payload;
				}
			},
			columns: column,
			language: $_LANG.datatable,
		};

		const oTable = $(`#${$_name}-datatable`).DataTable(cfg);
		init_Table();
		
		// Add onChange callback to range-filter after init_Table() initializes flatpickr
		setTimeout(function() {
			const rangeInput = $("#check_in_out_period");
			if (rangeInput.length > 0 && rangeInput[0]._flatpickr) {
				const fp = rangeInput[0]._flatpickr;
				fp.config.onChange.push(function(selectedDates, dateStr, instance) {
					if (selectedDates.length === 2) {
						// Trigger change event to reload datatable
						rangeInput.trigger('change');
					}
				});
			}
			
			// Toggle check_in_out_period after flatpickr is initialized
			toggleCheckInOutPeriod();
		}, 600);
	}
}

window.setReloadDataTable = function (bool = false) {
	($(`#${$_name}-datatable`).length > 0) && $(`#${$_name}-datatable`).DataTable().ajax.reload(null, bool);
}

window.setSort = function (id, move) {
	event.preventDefault();

	if ($_link_sort.length > 0) {
		$.ajax({
			url: $_link_sort,
			type: "POST",
			data: { id: id, move: move },
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		});
	};
};

window.setDefault = function (id) {
	event.preventDefault();

	if ($_link_default.length > 0) {
		$.ajax({
			url: $_link_default,
			type: "POST",
			data: { id: id },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		})
	}
};

window.setStatus = function (id) {
	event.preventDefault();

	if ($_link_status.length > 0) {
		$.ajax({
			url: $_link_status,
			type: "POST",
			data: { id: id },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		})
	}
};

window.setDelete = function (id) {
	event.preventDefault();

	if ($_link_delete.length > 0) {
		$.ajax({
			url: $_link_delete,
			type: "POST",
			data: { id: id, },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());

				if (resp.limit)
					$(`#add`).removeClass('d-none');
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		});
	}
};

window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();

	if ($_link_save.length > 0) {
		($_config.form.navbar.seo.status) && mwzGenerateMatadata(0);
		$(`#submit`).prop('disabled', true);
		const frm = $(`#${$_name}_frm`);
		const frm_data = new FormData($(frm)[0]);

		$.ajax({
			url: $_link_save,
			type: "POST",
			data: frm_data,
			contentType: false,
			processData: false,
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			beforeSend: function (xhr) {
				var rules = [], msg = [];

				if ($_config.form.navbar.translate.status) {
					$.each($_lang, function (i, lang) {
						$.each($_config.form.navbar.translate.input, function (k, e) {
							rules[`${k}_${lang}`] = (k != "name") ? { required: e.validate && e.status } : { required: e.validate && e.status, maxlength: 255 };
							msg[`${k}_${lang}`] = { required: $(frm).find(`[name="${k}_${lang}"]`).attr('placeholder') };
						});
					});
				}
				if ($_config.form.sidebar.setting.status) {
					$.each($_config.form.sidebar.setting.input, function (k, e) {
						rules[`${k}`] = { required: e.status && e.validate };
						msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
					});
				}

				mwz_validate($(frm), rules, msg);

				if (!frm_valid($(frm))) {
					$(`#submit`).prop('disabled', false);
					return false;
				}

				return true;
			},
			success: function (resp) {
				mwz_noti("success", resp.msg, window.location.replace(resp.url));
			},
			error: function (xhr, status, thrown) {
				$(`#submit`).prop('disabled', false);
				ajax_error(xhr, status, thrown);
			}
		});
	}
};

/**
 * Export timeline - Show format selection modal
 */
window.exportTimeline = function () {
	$('#exportModal').modal('show');
};

/**
 * Select export format and download
 */
window.selectExportFormat = function (format) {
	// Add visual fee2dback
	$('.export-option').css('border', '2px solid transparent');
	event.currentTarget.style.border = '2px solid #0d6efd';
	
	// Close modal and trigger download
	setTimeout(function() {
		$('#exportModal').modal('hide');
		
		const params = new URLSearchParams();
		params.set('format', format);

		const filterSource = Object.keys(window.__timelineFilters || {}).length
			? window.__timelineFilters
			: collectTimelineFilters();
		console.log('export filter cache', window.__timelineFilters);
		console.log('export filter dom', collectTimelineFilters());
		console.log('export using source', filterSource);

		Object.entries(filterSource).forEach(function ([name, value]) {
			if (value === undefined || value === null || value === '' || (Array.isArray(value) && value.length === 0)) return;
			if (name === 'filter[period]' && value === '00') return;

			if (Array.isArray(value)) {
				value.forEach(function (val) {
					if (val !== '') params.append(name, val);
				});
			} else {
				params.append(name, value);
			}
		});

		const exportUrl = $_link_export + '?' + params.toString();
		window.location.href = exportUrl;
	}, 300);
};