<?php

namespace Modules\Member\app\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Modules\Member\Database\factories\MemberFactory;
use Kalnoy\Nestedset\NodeTrait;

class Member extends Authenticatable
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'type',
		'code',
		'password',
		'confirm_password',
		'name',
		'email',
		'department',
		'position',
		'is_active',
		'parent_id',
		'lavel_id',
		'approve_by_first_id',
		'approve_by_second_id',
		'status',
		'role',
	];

	/**
	 * The attributes that should be hidden for serialization.
	 */
	protected $hidden = [
		'password',
		'confirm_password',
	];

	/**
	 * The attributes that should be cast.
	 */
	protected $casts = [
		// Removed array casting to store as plain string instead of JSON
		// 'code' => 'array',
		// 'email' => 'array',
		// 'name' => 'array',
		// 'department' => 'array',
		// 'position' => 'array',
	];

	protected $table = 'member';
	protected $primaryKey = 'id';

	protected static function boot(): void
	{
		parent::boot();
		// static::deleting(function ($model) {
		// 	$model->langs()->delete();
		// });
	}


	public function lavel()
	{
		return $this->hasOne(MemberLavel::class, 'id', 'lavel_id');
	}

	public function parent()
	{
		return $this->hasOne(Member::class, 'id', 'parent_id');
	}

	public function approve_by_first()
	{
		return $this->hasOne(Member::class, 'id', 'approve_by_first_id');
	}

	public function approve_by_second()
	{
		return $this->hasOne(Member::class, 'id', 'approve_by_second_id');
	}

	// public function local()
	// {
	// 	return $this->hasOne(PageTranslate::class, 'page_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
	// }

	// public function default()
	// {
	// 	return $this->hasOne(PageTranslate::class, 'page_id', 'id')->where('lang', config('app.fallback_locale'));
	// }
}
