<?php

namespace Modules\Member\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Route;
use Modules\Member\app\Models\Member;
use Modules\Member\app\Models\MemberManage;
use Modules\Mwz\app\Http\Controllers\AdminController;

class MemberManageAdminController extends AdminController
{
    private $module, $method, $action, $config;

    /**
     * Function : construct
     * Dev : Wan
     * Update Date : 22 Jan 2025
     */
    public function __construct()
    {
        $routeName = Route::currentRouteName();
		if ($routeName) {
			$explode = explode('.', $routeName);
			$this->module = $explode[1] ?? '';
			$this->method = $explode[2] ?? '';
			$this->action = $explode[3] ?? '';
		} else {
			$this->module = '';
			$this->method = '';
			$this->action = '';
		}

        self::$navbar = [
            ['name' => __("member::manage.{$this->module}.title"), 'url' => null],
            ['name' => __("member::manage.{$this->module}.name"), 'url' => route_has("admin.manage.{$this->method}.index")]
        ];
        $this->config = config("member.manage.{$this->module}");
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $limit = false;
        if (!empty($this->config['setting']['limit']['status']))
            $limit = MemberManage::whereNotNull('parent_id')->count() >= $this->config['setting']['limit']['max'];
        return view('member::manage.index', ['navbar' => self::$navbar, 'config' => $this->config, 'method' => $this->method, 'type' => $this->module, 'limit' => $limit]);
    }

    public function datatable_ajax(Request $request)
    {
        if ($request->ajax()) {
            //init datatable
            $dt_column = ['_lft'];
            foreach ($this->config['table']['header'] as $h) {
                if (!empty($h['status']))
                    $dt_column[] = $h['column'];
            }
            if (!empty($this->config['table']['btn']['sort']))
                $dt_column[] = 'sort';
            array_push($dt_column, 'updated_at', 'action');

            $dt_order = $request->get('order')[0]['column'];
            $dt_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];
            $dt_filter = $request->get('filter');

            // create Content object
            $req = new MemberManage();

            // search 
            if (!empty($dt_search))
                $req = $req->where('name', 'like', "%{$dt_search}%");

            // count all 
            $dt_total = $req->count();
            if ($dt_order == 0 && empty($this->config['table']['btn']['sort']))
                $req = $req->orderBy('updated_at', 'DESC');
            else
                $req = $req->orderBy($dt_column[$dt_order], $dt_dir);

            $resp =    $req->offset($dt_start)
                ->limit($dt_length)
                ->get();
            // prepare datatable for response
            $tables = datatables($resp)
                ->addIndexColumn()
                ->setRowId('id')
                ->setRowClass('member_row')
                ->setTotalRecords($dt_total)
                ->setFilteredRecords($dt_total)
                ->setOffset($dt_start)
                ->editColumn('name', function ($record) {
                    return limit($record->name ?? '', 50);
                })->editColumn('department', function ($record) {
                    return $record->department ?? '-';
                })->editColumn('position', function ($record) {
                    return $record->position ?? '-';
                })->editColumn('email', function ($record) {
                    return $record->email ?? '-';
                })->editColumn('sort', function ($record) use ($dt_order) {
                    if (!empty($this->config['table']['btn']['sort']))
                        return self::btn_sort("admin.{$this->module}.{$this->method}.set_sort", $record->id, 'setSort', 0, $dt_order != 0);
                })->editColumn('updated_at', function ($record) {
                    return str_replace(' ', '<br>', date("Y-m-d H:i:s", strtotime($record->updated_at)));
                })->addColumn('action', function ($record) {
                    $btn = '<div class="button-list">';
                    if (!empty($this->config['table']['btn']['status']))
                        $btn .= self::btn_status("admin.{$this->module}.{$this->method}.set_status", $record->id, 'setStatus', $record->status);
                    if (!empty($this->config['table']['btn']['edit']))
                        $btn .= self::btn_route("admin.{$this->module}.{$this->method}.edit", $record->id);
                    if (!empty($this->config['table']['btn']['delete']))
                        $btn .= self::btn_delete("admin.{$this->module}.{$this->method}.set_delete", $record->id, 'setDelete');

                    $btn .= '</div>';

                    return $btn;
                })->escapeColumns([]);
            // response datatable json
            return $tables->make(true);
        }
    }

    public function form()
    {
        return view('member::manage.form');
    }

    public function save()
    {
        return view('member::manage.save');
    }

    public function set_sort()
    {
        return view('member::manage.set_sort');
    }

    public function set_default()
    {
        return view('member::manage.set_default');
    }

    public function set_status()
    {
        return view('member::manage.set_status');
    }

    public function set_delete()
    {
        return view('member::manage.set_delete');
    }

    public function get_list(Request $request)
    {
        $filter = $request->get('parent');
        $req = Member::where('type', $this->module);
        if (!empty($filter)) {
            if (!empty($filter['search'])) {
                // Search in string name field
                $req = $req->where('name', 'LIKE', "%{$filter['search']}%");
            }
            if (!empty($filter['id']))
                $req = $req->where('id', '<>', $filter['id']);
                $req = $req->where('lavel_id','=',($filter['lavel_id'] - 1));
        }
        if (!empty($this->config['setting']['limit_parent']['status']))
            $req = $req->having('depth', '<=', $this->config['setting']['limit_parent']['level']);

        $data = $req->get();

        $result = [];
        foreach ($data as $list) {
            $result[] = ['id' => $list->id, 'text' => $list->name ?? '', 'image' => $list->image ?? ''];
        }
        return self::response(['results' => $result], 200);
    }
}