<?php

use Illuminate\Support\Facades\Route;
use Modules\Frontend\app\Http\Controllers\FrontendController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| กำหนดเส้นทางของ Frontend
|
*/

// ✅ Default resource (ถ้าต้องการ RESTful)
Route::resource('frontend', FrontendController::class)->names('frontend');

// ✅ Routes หลัก
Route::get('/', [FrontendController::class, 'index'])->name('frontend.index');
Route::get('/reset-password/{id}', [FrontendController::class, 'resetPassword'])->name('frontend.reset-password');
Route::post('/reset-password/{id}', [FrontendController::class, 'updatePassword'])->name('frontend.reset-password.update');
Route::get('/login', [FrontendController::class, 'login'])->name('frontend.login');
Route::get('/check', [FrontendController::class, 'check'])->name('frontend.check');
Route::get('/recorddatamanager', [FrontendController::class, 'recorddatamanager'])->name('frontend.recorddatamanager');
Route::get('/personalinformation', [FrontendController::class, 'personalinformation'])->name('frontend.personalinformation');
Route::get('/personalinformation/export-pdf', [FrontendController::class, 'exportTransportationPdf'])->name('frontend.personalinformation.export');
Route::get('/requestapproval', [FrontendController::class, 'requestapproval'])->name('frontend.requestapproval');
Route::get('/recorddatabu', [FrontendController::class, 'recorddatabu'])->name('frontend.recorddatabu');
Route::get('/approvaldetails', [FrontendController::class, 'approvaldetails'])->name('frontend.approvaldetails');
Route::get('/checkout_map', [FrontendController::class, 'checkout_map'])->name('frontend.checkout_map');

// ✅ Routes อื่น ๆ (เผื่อใช้ในอนาคต)
// Route::get('/articles', [FrontendController::class, 'articles'])->name('frontend.articles');
// Route::get('/contact', [FrontendController::class, 'contact'])->name('frontend.contact');
// Route::get('/privacy', [FrontendController::class, 'privacy'])->name('frontend.privacy');
// Route::get('/service-category', [FrontendController::class, 'serviceCategory'])->name('frontend.service-category');
// Route::get('/service-detail', [FrontendController::class, 'serviceDetail'])->name('frontend.service-detail');
// Route::get('/services', [FrontendController::class, 'services'])->name('frontend.services');
// Route::get('/customer-story', [FrontendController::class, 'customerStory'])->name('frontend.customer-story');
// Route::get('/customer-story-detail', [FrontendController::class, 'customerStoryDetail'])->name('frontend.customer-story-detail');

// ✅ Slug (ไม่มี locale)
Route::group(['middleware' => 'setlocale'], function () {
    Route::get('/{slug}', [FrontendController::class, 'slug'])
        ->where('slug', '^((?!admin)(?!api).)+$')
        ->name('frontend.slug');
});

// ✅ Slug (รองรับ multi-locale เช่น /th/ , /en/)
Route::group([
    'prefix' => '{locale?}', 
    'where' => ['locale' => '[a-zA-Z]{2}'], 
    'middleware' => 'setlocale'
], function () {
    Route::get('/', [FrontendController::class, 'index'])->name('lang.frontend.index');
    Route::get('/{slug}', [FrontendController::class, 'slug'])
        ->where('slug', '^((?!admin)(?!api).)+$')
        ->name('lang.frontend.slug');
});
