@extends('frontend::layouts.applogin')

@push('styles')
  <link href="{{ asset('assets/frontend/css/resetpass.css') }}" rel="stylesheet">
@endpush

@section('content')
<!-- ใช้ #login-page และ .login-box เหมือนหน้า login -->
<div id="login-page">
  <div class="login-box">
    {{-- <img src="{{ asset('assets/frontend/images/logo.png') }}" alt="Logo"> --}}
    <h2>ตั้งรหัสผ่านใหม่</h2>
    <p class="subtitle">โปรดตั้งรหัสผ่านใหม่ของคุณ</p>
    <p class="description">กรุณากรอกรหัสผ่านใหม่ และยืนยันรหัสผ่านเพื่อรีเซ็ตรหัสผ่านของคุณ</p>

    <form action="{{ route('frontend.reset-password.update', $member_id) }}" method="POST">
      @csrf

      <div class="form-group" style="position: relative;">
        <label class="tb-menu-topleft">รหัสผ่านใหม่</label>
        <input 
          type="password" 
          name="password" 
          id="password"
          placeholder="กรอกรหัสผ่านใหม่"
          required
          minlength="8"
          class="@error('password') is-invalid @enderror"
          style="padding-right: 40px;"
        >
        <span onclick="togglePassword('password', this)" style="position:absolute;top:38px;right:14px;cursor:pointer;">
          <i class="fas fa-eye" id="toggle-password-eye"></i>
        </span>
        @error('password')
          <span class="text-danger tb-menu-topleft">{{ $message }}</span>
        @enderror
      </div>

      <div class="form-group" style="position: relative;">
        <label class="tb-menu-topleft">ยืนยันรหัสผ่านใหม่</label>
        <input 
          type="password" 
          name="password_confirmation" 
          id="password_confirmation"
          placeholder="ยืนยันรหัสผ่านใหม่"
          required
          minlength="8"
          class="@error('password_confirmation') is-invalid @enderror"
          style="padding-right: 40px;"
        >
        <span onclick="togglePassword('password_confirmation', this)" style="position:absolute;top:38px;right:14px;cursor:pointer;">
          <i class="fas fa-eye" id="toggle-password-confirmation-eye"></i>
        </span>
        @error('password_confirmation')
          <span class="text-danger tb-menu-topleft">{{ $message }}</span>
        @enderror
      </div>

      <button type="submit" id="reset-btn">
        <i class="fas fa-key"></i> ตั้งรหัสผ่านใหม่
      </button>
    </form>

  </div>
</div>

@if(session('success'))
<script>
  document.addEventListener('DOMContentLoaded', function() {
    Swal.fire({
      icon: 'success',
      title: 'สำเร็จ!',
      html: '{{ session('success') }}',
      confirmButtonText: 'ตกลง',
      confirmButtonColor: '#28a745',
      showClass: {
        popup: 'animate__animated animate__fadeInDown'
      },
      hideClass: {
        popup: 'animate__animated animate__fadeOutUp'
      }
    }).then(function() {
      window.location.href = "{{ route('frontend.login') }}";
    });
  });
</script>
@endif

@if(session('error'))
<script>
  document.addEventListener('DOMContentLoaded', function() {
    Swal.fire({
      icon: 'error',
      title: 'เกิดข้อผิดพลาด',
      html: '{{ session('error') }}',
      confirmButtonText: 'ตกลง',
      confirmButtonColor: '#e60303',
      showClass: {
        popup: 'animate__animated animate__fadeInDown'
      },
      hideClass: {
        popup: 'animate__animated animate__fadeOutUp'
      }
    });
  });
</script>
@endif

@push('scripts')
<script>
  /**
   * Toggle Password Visibility
   * @param {string} fieldId - ID of the password input field
   * @param {HTMLElement} iconElement - The icon element that was clicked
   */
  function togglePassword(fieldId, iconElement) {
    const passwordField = document.getElementById(fieldId);
    const icon = iconElement.querySelector('i');
    
    if (passwordField.type === 'password') {
      // แสดงรหัสผ่าน
      passwordField.type = 'text';
      icon.classList.remove('fa-eye');
      icon.classList.add('fa-eye-slash');
    } else {
      // ซ่อนรหัสผ่าน
      passwordField.type = 'password';
      icon.classList.remove('fa-eye-slash');
      icon.classList.add('fa-eye');
    }
  }
</script>
@endpush
@endsection
