<div>
    <!-- หน้า Login -->
    <div id="login-page">
        <div class="login-box">
            <center><img src="{{ check_file(setting()->logo_header ?? '', asset('assets/frontend/images/logo.png')) }}"
                    alt="Logo"></center>
            <h2>เข้าสู่ระบบ</h2>

            <form wire:submit.prevent="login">
                <div class="form-group">
                    <label class="tb-menu-topleft">รหัสพนักงาน</label>
                    <input type="text" wire:model.defer="empCode" placeholder="กรอกรหัสพนักงาน EMP001"
                        class="@error('empCode') is-invalid @enderror">
                    @error('empCode')
                        <span class="text-danger tb-menu-topleft">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group pt-3 pb-3">
                    <label class="tb-menu-topleft">รหัสผ่าน</label>
                    <input type="password"
                        wire:model.defer="password"
                        placeholder="กรอกรหัสผ่าน"
                        pattern="[!-~]+"
                        title="ใช้ได้เฉพาะภาษาอังกฤษ ตัวเลข และอักขระพิเศษ"
                        class="@error('password') is-invalid @enderror">
                    @error('password')
                        <span class="text-danger tb-menu-topleft">{{ $message }}</span>
                    @enderror
                </div>

                {{-- <div class="form-group">
          <label class="remember-me">
            <input type="checkbox" wire:model="remember"> จดจำฉันไว้
          </label>
        </div> --}}

                <button type="submit" id="login-btn"
                    class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounde btn-login">
                    <span wire:loading.remove wire:target="login">เข้าสู่ระบบ</span>
                    <span wire:loading wire:target="login">กำลังเข้าสู่ระบบ...</span>
                </button>
            </form>

            <div class="forgot">
                <a wire:click="showForgotPasswordPopup" style="cursor: pointer;">ลืมรหัสผ่าน?</a>
            </div>
        </div>
    </div>

    <!-- Popup ลืมรหัสผ่าน -->
    <div id="popup" class="popup" style="display: {{ $showForgotPassword ? 'flex' : 'none' }}">
        <div class="popup-content popup-content-relative">
            <button wire:click="closeForgotPasswordPopup" class=" btn-close" id="popup-close">x</i></button>

            <h3>ลืมรหัสผ่าน</h3>
            <p>กรอกอีเมลที่ลงทะเบียน ระบบจะส่งลิงก์ Reset Password ไปทางอีเมล</p>

            <form wire:submit.prevent="sendResetLink">
                <input type="email" wire:model.defer="resetEmail" placeholder="example@email.com"
                    class="@error('resetEmail') is-invalid @enderror" />
                @error('resetEmail')
                    <span class="text-danger">{{ $message }}</span>
                @enderror

                <button type="submit" id="send-reset">
                    <span wire:loading.remove wire:target="sendResetLink">ส่งลิงก์</span>
                    <span wire:loading wire:target="sendResetLink">กำลังส่ง...</span>
                </button>
            </form>
        </div>
    </div>

    @push('scripts')
        <script>
            // SweetAlert2 สำหรับ Error Message
            window.addEventListener('show-error', event => {
                Swal.fire({
                    icon: 'error',
                    title: 'เกิดข้อผิดพลาด',
                    html: event.detail.message,
                    confirmButtonText: 'ตกลง',
                    confirmButtonColor: '#e74c3c',
                    backdrop: '#292a86',
                    showClass: {
                        popup: 'animate__animated animate__fadeInDown'
                    },
                    hideClass: {
                        popup: 'animate__animated animate__fadeOutUp'
                    }
                });
            });

            // SweetAlert2 สำหรับ Success Message
            window.addEventListener('show-success', event => {
                // ซ่อนฟอร์ม login ทันที
                const loginPage = document.getElementById('login-page');
                if (loginPage) {
                    loginPage.style.display = 'none';
                }

                Swal.fire({
                    icon: 'success',
                    title: 'สำเร็จ',
                    html: event.detail.message || 'เข้าสู่ระบบสำเร็จ',
                    showConfirmButton: false,
                    timer: 1500,
                    backdrop: '#292a86',
                    showClass: {
                        popup: 'animate__animated animate__fadeInDown'
                    },
                    hideClass: {
                        popup: 'animate__animated animate__fadeOutUp'
                    }
                });
            });

            // จำกัดให้ช่องรหัสผ่านพิมพ์ได้เฉพาะภาษาอังกฤษ ตัวเลข และอักขระพิเศษ
            document.addEventListener('input', function(e) {
                const target = e.target;
                if (
                    target.matches('input[type="password"][wire\\:model\\.defer="password"]')
                ) {
                    const original = target.value;
                    // อนุญาตเฉพาะ ASCII 33-126 (ไม่รวมเว้นวรรค)
                    const filtered = original.replace(/[^\x21-\x7E]/g, '');

                    if (original !== filtered) {
                        target.value = filtered;
                        // อัปเดตค่าใน Livewire ให้ตรงกับช่องอินพุต
                        if (typeof @this !== 'undefined') {
                            @this.set('password', filtered);
                        }
                    }
                }
            });

            // ปิด popup อัตโนมัติหลังจากส่งอีเมลสำเร็จ
            window.addEventListener('close-popup-after-delay', () => {
                setTimeout(() => {
                    @this.closeForgotPasswordPopup();
                }, 2000);
            });
        </script>
    @endpush
</div>
