<div>
    @if (empty($type))
        <x-frontend::member-info-card :member="$member" />
    @endif
    <!-- ส่วนที่ 2: Check-in / Check-out -->
    <div class="card">
        <h2>Check-in / Check-out</h2>

        <!-- Flash Messages -->
        @if (session()->has('success'))
            <div class="alert alert-success bg-green-100 text-green-800 p-2.5 mb-4 border border-green-300 rounded">
                {{ session('success') }}
            </div>
        @endif

        @if (session()->has('error'))
            <div class="alert alert-danger bg-red-100 text-red-800 p-2.5 mb-4 border border-red-300 rounded">
                {{ session('error') }}
            </div>
        @endif

        <div class="latest-checkin-box">
            <div class="font-bold lg:text-3xl md:text-4xl py-3 text-black">📍 ข้อมูลล่าสุดจาก Check-in</div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-4 py-3 pl-4">
                <div>
                    <p><strong>Latitude:</strong> <span id="latestLat">{{ $checkin->lat }}</span></p>
                </div>
                <div>
                    <p><strong>Longitude:</strong> <span id="latestLng">{{ $checkin->lng }}</span></p>
                </div>
            </div>
        </div>
        <div id="checkoutForm" class="">
            <p class="muted">ข้อมูลจาก Check-in จะแสดงที่นี่ (แก้ไขได้)</p>
            <!-- ฟอร์มแก้ไข -->
            <form wire:submit="saveCheckoutEdit">
                <!-- Responsive: lg: 2 columns, <lg: 1 column -->
                <div id="checkoutEditForm" class="grid grid-cols-1 lg:grid-cols-2 gap-4"
                    style="{{ $checkoutEditForm ? 'display: block;' : 'display: none;' }}">
                    <!-- Column 1 -->
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                        <div class="col-span-1">
                            <div class="form-group">
                                <label for="currentPlaceOut">ชื่อสถานที่ปัจจุบัน1</label>
                                <input type="text" id="currentPlaceOut" wire:model="current_place" class="form-control">
                                @error('current_place')
                                    <small class="error-msg">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-span-1">
                            <div class="form-group">
                                <label for="targetPlaceOut">ชื่อสถานที่จะไป</label>
                                <input type="text" id="targetPlaceOut" wire:model="target_place" class="form-control">
                                @error('target_place')
                                    <small class="error-msg">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <!-- Column 2 -->
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                        <div class="col-span-1">
                            <div class="form-group">
                                <label for="reasonOut">เหตุผลที่ไปเนื่องจาก</label>
                                <input type="text" id="reasonOut" wire:model="reason" class="form-control">
                                @error('reason')
                                    <small class="error-msg">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-span-1">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                        
                        <div class="col-span-1">
                            <div class="flex flex-row gap-3 mt-4 flex-wrap">
                                <button type="button" id="cancelEditCheckout" class="modal-btn-cancel w-full sm:w-auto"
                                    style="white-space: nowrap;" wire:click="cancelEditCheckout">ยกเลิก</button>
                                <button type="submit" id="saveCheckoutEdit" class="btn-save-checkout w-full sm:w-auto"
                                    style="white-space: nowrap;">บันทึกข้อมูล Check-out</button>
                            </div>
                        </div>
                        <div class="col-span-1">
                        </div>
                    </div>
                </div>
            </form>
            <div id="checkoutPreview"
                class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-5 {{ $checkoutEditForm ? 'hidden' : '' }}">
                <div class="col-span-1 py-2">
                    <strong>ชื่อสถานที่ปัจจุบัน:</strong>
                    <p><span id="previewCurrentPlace">{{ $checkin->current_place }}</span></p>
                </div>
                <div class="col-span-1 py-2">
                    <strong>ชื่อสถานที่จะไป:</strong>
                    <p><span id="previewTargetPlace">{{ $checkin->target_place }}</span></p>
                </div>
                <div class="col-span-1 py-2">
                    <strong>เหตุผลที่ไปเนื่องจาก:</strong>
                    <p><span id="previewReason">{{ $checkin->reason }}</span></p>
                </div>
                <div class="col-span-1 py-2">
                    <strong>วันที่และเวลา Check-in:</strong>
                    <p><span id="previewCheckinTime">{{ str_date($checkin->time, 'd m y H:i') }}</span></p>
                </div>
                <div class="col-span-1 py-2">
                    <strong>เลือกเวลา Check-out:</strong>
                    <input type="hidden" id="checkoutTime" wire:model="checkoutTime"
                        value="{{ str_date(now(), 'd m y H:i') }}">
                    <p class="d-flex align-items-center">{{ str_date(now(), 'd m y H:i') }}</p>
                    <small id="error-checkinTimeOutPreview" class="error-msg"></small>
                </div>
            </div>

            <!-- ปุ่ม ครอบทั้งแถว -->
            <div
                class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-2 lg:grid-cols-5  {{ $checkoutEditForm ? 'hidden' : '' }}">
                <div class="col-span-1 md:p-3 md:pl-0 sm:pt-1 py-2 sm:pr-4">
                    <button type="button" id="editCheckout"
                        class="btn-edit-checkout whitespace-nowrap min-w-[150px] px-6 py-2.5 w-full lg:w-auto"
                        wire:click="editCheckout">แก้ไขข้อมูล</button>
                </div>
                <div class="col-span-1  md:p-3 md:pl-0 sm:pt-1 py-2">
                    <button type="button"
                        class="btn-save-checkout whitespace-nowrap min-w-[150px] px-6 py-2.5 w-full lg:w-auto"
                        wire:click="saveCheckoutPreview">บันทึกข้อมูล Check-out</button>
                </div>
            </div>
        </div>
        <p class="muted"><br>* ความแม่นยำของพิกัด ±5–10 เมตร</p>
    </div>
    <!-- ตารางประวัติ -->
    @livewire('frontend::list-data.request-list', ['page' => $type])

    <!-- Modal แสดงระยะทาง -->
    @if ($showDistanceModal || $distanceError)
        <div class="modal-overlay flex overflow-y-auto py-4">
            <div class="modal-content w-full max-w-2xl mx-4 sm:mx-auto my-auto">
                <button wire:click="closeDistanceModal" class="modal-close-btn sm:pr-3 rounded-full bg-red-500 text-white">✕</button>
                @if ($distanceError)
                    <!-- Error State -->
                    <div class="error-state">
                        <div class="modal-icon-error">⚠️</div>
                        <h2 class="error-title">ไม่สามารถคำนวณระยะทางได้</h2>
                        <p class="error-message">{{ $errorMessage }}</p>
                        <div class="flex flex-col sm:flex-row gap-3 mt-4">
                            <button wire:click="closeDistanceModal" class="modal-btn-secondary w-full sm:w-auto">ปิด</button>
                            <button wire:click="calculateDistance" class="modal-btn-confirm w-full sm:w-auto">ลองใหม่</button>
                        </div>
                    </div>
                @else
                    <!-- Distance Summary State -->
                    <div class="flex flex-col">
                        <div class="modal-icon-map text-center mt-0">🗺️</div>
                        <h2 class="modal-title-large text-center mb-4">สรุประยะทาง</h2>
                        <!-- กล่องข้อมูลระยะทาง -->
                        <div class="distance-summary-box">
                            <div class="grid grid-cols-1 sm:grid-cols-2">
                                <div class="summary-label font-semibold">จุดเริ่มต้น:</div>
                                <div class="summary-value break-words">
                                    {{ !empty($current_place) ? $current_place : $checkin->current_place }}
                                </div>
                                <div class="summary-label font-semibold">จุดปลายทาง:</div>
                                <div class="summary-value break-words">
                                    {{ !empty($target_place) ? $target_place : $checkin->target_place }}
                                </div>
                                <div class="summary-label font-semibold">ระยะทาง:</div>
                                <div class="summary-value-primary whitespace-nowrap">
                                    {{ number_format($distance_km, 2) }} กม.
                                </div>
                                <div class="summary-label font-semibold">Check-in:</div>
                                <div class="summary-value whitespace-nowrap">
                                    {{ $checkin->time->format('d/m/Y H:i') }}
                                </div>
                                <div class="summary-label font-semibold">Check-out:</div>
                                <div class="summary-value whitespace-nowrap">
                                    {{ now()->format('d/m/Y H:i') }}
                                </div>
                            </div>
                            <!-- Location Details -->
                            <div class="mt-4 bg-gray-100 rounded">
                                <div class="mb-2.5">
                                    <strong class="text-blue-500 block">📍 ตำแหน่ง Check-in:</strong>
                                    <p class="mt-1 sm:ml-5 ml-2 text-sm text-gray-600 mb-0 break-all">
                                        @if ($checkin_location_name)
                                            {{ $checkin_location_name }}
                                        @else
                                            Lat: {{ $checkin->lat }}, Lng: {{ $checkin->lng }}
                                        @endif
                                    </p>
                                </div>
                                <div>
                                    <strong class="text-green-500 block">📍 ตำแหน่ง Check-out:</strong>
                                    <p class="mt-1 sm:ml-5 ml-2 text-sm text-gray-600 mb-0 break-all">
                                        @if ($checkout_location_name)
                                            {{ $checkout_location_name }}
                                        @else
                                            Lat: {{ $checkout_lat }}, Lng: {{ $checkout_lng }}
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- รวมปุ่มในกล่อง scroll โดยติดชิดล่างเสมอ และไม่ถูก scroll ไปกับเนื้อหาด้านบน (sticky/absolute พื้นที่ box)-->
                        <div class="flex flex-col sm:flex-row gap-3 mt-4 items-center justify-center pb-2">
                            <button wire:click="closeDistanceModal" class="modal-btn-cancel w-full sm:w-auto">
                                ยกเลิก
                            </button>
                            <button wire:click="confirmSaveCheckout" class="modal-btn-confirm modal-btn-confirm-large w-full sm:w-auto">
                                ยืนยันบันทึก
                            </button>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    @endif

    <!-- Hidden inputs for geolocation -->
    <input type="hidden" wire:model="checkout_lat" id="checkoutLat">
    <input type="hidden" wire:model="checkout_lng" id="checkoutLng">
    <input type="hidden" wire:model="checkout_address" id="checkoutAddress">

    @push('scripts')
        <script>
            // Get geolocation when form is submitted
            document.addEventListener('livewire:init', () => {
                Livewire.on('get-checkout-location', () => {
                    if (navigator.geolocation) {
                        navigator.geolocation.getCurrentPosition(
                            (position) => {
                                @this.set('checkout_lat', position.coords.latitude);
                                @this.set('checkout_lng', position.coords.longitude);

                                // Get address from coordinates using Google Geocoding API
                                if (typeof google !== 'undefined' && google.maps) {
                                    const geocoder = new google.maps.Geocoder();
                                    const latlng = {
                                        lat: position.coords.latitude,
                                        lng: position.coords.longitude
                                    };

                                    geocoder.geocode({
                                        location: latlng
                                    }, (results, status) => {
                                        if (status === 'OK' && results[0]) {
                                            @this.set('checkout_address', results[0]
                                                .formatted_address);
                                        }
                                    });
                                }
                            },
                            (error) => {
                                alert('⚠️ ไม่สามารถเข้าถึงตำแหน่งของคุณได้ กรุณาอนุญาตการเข้าถึงตำแหน่ง');
                                console.error('Geolocation error:', error);
                            }
                        );
                    } else {
                        alert('⚠️ เบราว์เซอร์ของคุณไม่รองรับ Geolocation');
                    }
                });

                // Get location and save for preview button
                Livewire.on('get-checkout-location-and-save', () => {
                    if (navigator.geolocation) {
                        navigator.geolocation.getCurrentPosition(
                            (position) => {
                                @this.set('checkout_lat', position.coords.latitude);
                                @this.set('checkout_lng', position.coords.longitude);

                                // Get address from coordinates using Google Geocoding API
                                if (typeof google !== 'undefined' && google.maps) {
                                    const geocoder = new google.maps.Geocoder();
                                    const latlng = {
                                        lat: position.coords.latitude,
                                        lng: position.coords.longitude
                                    };

                                    geocoder.geocode({
                                        location: latlng
                                    }, (results, status) => {
                                        if (status === 'OK' && results[0]) {
                                            @this.set('checkout_address', results[0]
                                                .formatted_address);
                                        }
                                        // Call saveCheckoutPreview again after getting location
                                        @this.call('saveCheckoutPreview');
                                    });
                                } else {
                                    // If Google Maps not available, just call save
                                    @this.call('saveCheckoutPreview');
                                }
                            },
                            (error) => {
                                alert('⚠️ ไม่สามารถเข้าถึงตำแหน่งของคุณได้ กรุณาอนุญาตการเข้าถึงตำแหน่ง');
                                console.error('Geolocation error:', error);
                            }
                        );
                    } else {
                        alert('⚠️ เบราว์เซอร์ของคุณไม่รองรับ Geolocation');
                    }
                });
            });

            // Automatically get location when edit form is shown
            document.addEventListener('DOMContentLoaded', function() {
                const form = document.querySelector('form[wire\\:submit="saveCheckoutEdit"]');
                if (form) {
                    form.addEventListener('submit', function(e) {
                        const checkoutLat = document.getElementById('checkoutLat').value;

                        // If location not yet obtained, get it first
                        if (!checkoutLat) {
                            e.preventDefault();

                            if (navigator.geolocation) {
                                navigator.geolocation.getCurrentPosition(
                                    (position) => {
                                        @this.set('checkout_lat', position.coords.latitude);
                                        @this.set('checkout_lng', position.coords.longitude);

                                        // Get address from coordinates
                                        if (typeof google !== 'undefined') {
                                            const geocoder = new google.maps.Geocoder();
                                            const latlng = {
                                                lat: position.coords.latitude,
                                                lng: position.coords.longitude
                                            };

                                            geocoder.geocode({
                                                location: latlng
                                            }, (results, status) => {
                                                if (status === 'OK' && results[0]) {
                                                    @this.set('checkout_address', results[0]
                                                        .formatted_address);
                                                }
                                                // Submit form after getting location
                                                form.dispatchEvent(new Event('submit', {
                                                    cancelable: true,
                                                    bubbles: true
                                                }));
                                            });
                                        } else {
                                            // Submit without address if Google Maps not loaded
                                            form.dispatchEvent(new Event('submit', {
                                                cancelable: true,
                                                bubbles: true
                                            }));
                                        }
                                    },
                                    (error) => {
                                        alert(
                                            '⚠️ ไม่สามารถเข้าถึงตำแหน่งของคุณได้ กรุณาอนุญาตการเข้าถึงตำแหน่ง'
                                        );
                                        console.error('Geolocation error:', error);
                                    }
                                );
                            } else {
                                alert('⚠️ เบราว์เซอร์ของคุณไม่รองรับ Geolocation');
                            }
                        }
                    });
                }
            });
        </script>
    @endpush
</div>
