<div>

    <x-frontend::member-info-card :member="$member" />
    <!-- ส่วนที่ 2: Check-in / Check-out -->
    <div class="card mt-5">
        <h2>Check-in / Check-out</h2>

        <!-- ปุ่ม Check-in -->
        <button class="btn-all text-center p-2 w-full lg:w-auto" wire:click="showCheckinForm()" id="btnCheckin">Check-in</button>

        {{-- class="hidden" --}}
        <div id="checkinForm" class="{{ $showCheckinForm ? '' : 'hidden' }}">
            <form wire:submit="saveCheckin">
                @csrf
                <label class="mt-3">เลือกสถานะ / เหตุผล</label>
                <div class="checkbox-group"></div>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                    <label
                        class="relative flex items-center justify-between border border-gray-300 rounded-xl p-4 
                                  hover:border-blue-500 hover:shadow-md transition cursor-pointer bg-white">
                        <span class="text-gray-800 font-medium">ลงเวลาทำงาน</span>
                        <input type="checkbox" wire:model="work_time" class="w-5 h-5 accent-blue-600 rounded">
                    </label>
                    
                    <label
                        class="relative flex items-center justify-between border border-gray-300 rounded-xl p-4 
                                  hover:border-blue-500 hover:shadow-md transition cursor-pointer bg-white">
                        <span class="text-gray-800 font-medium">ขับรถ</span>
                        <input type="checkbox" wire:model="drive_car" class="w-5 h-5 accent-blue-600 rounded">
                    </label>
                </div>
                @error('checkbox_status')
                    <small class="text-red-500 block mt-2">{{ $message }}</small>
                @enderror

                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 pt-3 pb-3">
                    <div>
                        <label for="placeName" class="blocktext-gray-700 mb-1">ชื่อสถานที่</label>
                        <input type="text" id="placeName" placeholder="เลือกสถานที่จาก Google Maps"
                            class="block w-full bg-gray-100 border border-gray-300 rounded-md py-2 px-3 text-gray-600 focus:outline-none"
                            readonly wire:model="place_name">
                        @error('place_name')
                            <small class="text-red-500">{{ $message }}</small>
                        @enderror
                    </div>
                    <div>
                        <label for="lat" class="block text-gray-700 mb-1">Latitude</label>
                        <input type="text" id="lat" placeholder="Latitude"
                            class="block w-full bg-gray-100 border border-gray-300 rounded-md py-2 px-3 text-gray-600 focus:outline-none"
                            readonly wire:model="lat" value="">
                        @error('lat')
                            <small class="text-red-500">{{ $message }}</small>
                        @enderror
                    </div>
                    <div>
                        <label for="lng" class="block text-gray-700 mb-1">Longitude</label>
                        <input type="text" id="lng" placeholder="Longitude"
                            class="block w-full bg-gray-100 border border-gray-300 rounded-md py-2 px-3 text-gray-600 focus:outline-none"
                            readonly wire:model="lng" value="">
                        @error('lng')
                            <small class="text-red-500">{{ $message }}</small>
                        @enderror
                    </div>
                </div>

                <div class="form-row-1col">
                    <div class="col-span-1">
                        <label for="address">รายละเอียดที่อยู่พิกัดปัจจุบัน</label>
                        <textarea id="address" placeholder="ดึงข้อมูลจาก Google Maps API" readonly wire:model="address"></textarea>
                        @error('address')
                            <small class="error-msg">{{ $message }}</small>
                        @enderror
                    </div>
                </div>

                <div class="form-row-4col">
                    <div class="col-span-1">
                        <label for="currentPlace">ชื่อสถานที่ปัจจุบัน</label>
                        <input type="text" id="currentPlace" placeholder="ใส่ชื่อสถานที่ปัจจุบัน"
                            wire:model="currentPlace">
                        @error('currentPlace')
                            <small class="error-msg">{{ $message }}</small>
                        @enderror
                    </div>
                    <div class="col-span-1">
                        <label for="targetPlace">ชื่อสถานที่จะไป</label>
                        <input type="text" id="targetPlace" placeholder="ใส่ชื่อสถานที่จะไป"
                            wire:model="targetPlace">
                        @error('targetPlace')
                            <small class="error-msg">{{ $message }}</small>
                        @enderror
                    </div>
                    <div class="col-span-1">
                        <label for="reason">เหตุผลที่ไปเนื่องจาก</label>
                        <input type="text" id="reason" placeholder="ใส่เหตุผล" wire:model="reason">
                        @error('reason')
                            <small class="error-msg">{{ $message }}</small>
                        @enderror
                    </div>
                    <div class="col-span-1">
                        <label for="checkinTime">วันที่และเวลา Check-in</label>
                        <p class="d-flex align-items-center">{{ now()->format('d/m/Y H:i') }}</p>
                    </div>
                </div>
                {{-- id="saveCheckin" --}}
                <button class="btn-all text-center p-2 w-full lg:w-auto" type="submit">บันทึกข้อมูล Check-in</button>
            </form>
        </div>
        <!-- ปุ่ม Check-out -->
        <button id="btnCheckout" class="hidden btn-checkout">Check-out</button>
        <p class="muted"><br>* ความแม่นยำของพิกัด ±5–10 เมตร</p>
    </div>
    @livewire('frontend::list-data.request-list', ['page' => $type ?? ''])
</div>

<script>
    document.addEventListener('check_out', function() {
        console.log("latestCheckinBox");

    });

    <
    script src = "{{ asset('modules/frontend/assets/js/recorddata.js') }}" >
</script>
<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCsTYM_vFrL0PuZ9cCVH3iAv3eWvsQmmpU&libraries=places&callback=initAutocomplete"
    async defer></script>
</script>
