@php
    use Modules\Frontend\app\Http\Controllers\FrontendInitController;
@endphp

<!-- Header -->
<header id="header">
    <div class="header-inner">
        <div class="container-fluid">
            <!--Logo-->
            @if (!empty($page_init['setting']['logo']['header']))
                <x-frontend::logo :href="route('frontend.check')" :src="$page_init['setting']['logo']['header']" />
            @endif
            <!--End: Logo-->

            <!--Header Extras-->
            <x-frontend::user-dropdown />
            <!--end: Header Extras-->

            <!--Navigation Resposnive Trigger-->
            @if (Auth::guard('member')->user()->lavel_id != 1)
                <div id="mainMenu-trigger">
                    <button class="lines-button x"> <span class="lines"></span> </button>
                </div>
            @endif
            <!--end: Navigation Resposnive Trigger-->

            <!--Navigation-->
            @if (!empty($page_init['menu']))
                <div id="mainMenu" class="sm-py-5 light menu-center">
                    <div class="container">
                        <nav>
                            <ul>
                                @foreach ($page_init['menu'] as $kk => $item)
                                    @if ($kk == 0)
                                        <li><a href="{{ FrontendInitController::CheckRole() }}" style="padding-left: 17px;">{!! $item['name'] ?? '' !!}</a></li>
                                    @else
                                        <li><a href="{{ route('frontend.personalinformation') }}" style="padding-left: 17px;">{{ $item['name'] ?? '' }}</a></li>
                                    @endif
                                @endforeach
                            </ul>
                        </nav>
                    </div>
                </div>
            @endif
            <!--end: Navigation-->
        </div>
    </div>
</header>
<!-- end: Header -->
