{{-- 
  ตัวอย่างการใส่ปุ่ม Logout ใน Header
  คัดลอกโค้ดนี้ไปใส่ในไฟล์ header ของคุณ
--}}

<header class="header">
    <div class="container">
        <div class="header-content">
            {{-- Logo --}}
            <div class="logo">
                <img src="{{ asset('assets/frontend/images/logo.png') }}" alt="Logo">
            </div>
            {{-- Navigation --}}
            <nav class="main-nav">
                <ul>
                    <li><a href="{{ route('frontend.index') }}">หน้าหลัก</a></li>
                    <li><a href="{{ route('frontend.recorddata') }}">บันทึกข้อมูล</a></li>
                    <li><a href="{{ route('frontend.personalinformation') }}">ข้อมูลส่วนตัว</a></li>
                </ul>
            </nav>

            {{-- User Info & Logout --}}
            <div class="user-section">
                @auth
                    <div class="user-info">
                        <span class="user-name">{{ Auth::user()->name }}</span>
                        <span class="user-role">({{ Auth::user()->role }})</span>
                    </div>
                    @livewire('frontend::logout-button')
                @else
                    <a href="{{ route('frontend.login') }}" class="btn btn-login">เข้าสู่ระบบ</a>
                @endauth
            </div>
        </div>
    </div>
</header>

<style>
.header {
    background: white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    padding: 15px 0;
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.logo img {
    height: 50px;
}

.main-nav ul {
    display: flex;
    list-style: none;
    gap: 30px;
    margin: 0;
    padding: 0;
}

.main-nav a {
    text-decoration: none;
    color: #333;
    font-weight: 500;
    transition: color 0.3s;
}

.main-nav a:hover {
    color: #667eea;
}

.user-section {
    display: flex;
    align-items: center;
    gap: 15px;
}

.user-info {
    text-align: right;
}

.user-name {
    display: block;
    font-weight: 600;
    color: #333;
}

.user-role {
    display: block;
    font-size: 12px;
    color: #666;
    text-transform: capitalize;
}

.btn-logout {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-logout:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
}

.btn-login {
    background: #667eea;
    color: white;
    padding: 10px 20px;
    border-radius: 5px;
    text-decoration: none;
    transition: all 0.3s;
}

.btn-login:hover {
    background: #764ba2;
    transform: translateY(-2px);
}
</style>

