@props([
    'user' => null,
])

@php
    $user = $user ?? Auth::guard('member')->user();
@endphp

<div class="header-extras">
    <div class="p-dropdown">
        <a href="#">
            <i class="fas fa-user-circle"></i>
            <span class="user-name mr-3">
                {{ explode(' ', $user->name ?? '')[0] }}
            </span>
        </a>
        <div class="p-dropdown-content">
            <div class="widget-myaccount">
                <h4>บัญชีของฉัน</h4>
                <div class="user-item">
                    <div class="cart-image">
                        <i class="fa fa-user"></i>
                    </div>
                    <div class="user-meta">
                        <a>{{ $user->name ?? '' }}</a>
                    </div>
                </div>
                <div class="user-item">
                    <div class="cart-image">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <div class="user-meta">
                        <a>{{ $user->code ?? '' }}</a>
                    </div>
                </div>
                @if (!empty($user->department))
                    <div class="user-item">
                        <div class="cart-image">
                            <i class="fas fa-user-cog"></i>
                        </div>
                        <div class="user-meta">
                            <a>{{ $user->department ?? '' }}</a>
                        </div>
                    </div>
                @endif
                @if (!empty($user->position))
                    <div class="user-item">
                        <div class="cart-image">
                            <i class="fas fa-user-cog"></i>
                        </div>
                        <div class="user-meta">
                            <a>{{ $user->position ?? '' }}</a>
                        </div>
                    </div>
                @endif
                @livewire('frontend::logout-button')
            </div>
        </div>
    </div>
</div>
