@props(['currentPage' => 1, 'totalPages' => 1, 'per_page' => 1, 'pages' => [], 'slug_id' => '', 'opt' => [],'total_items' => 1])
@if ($totalPages > 1)
    <section class="sect-pagination pt-5">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                    <nav aria-label="Product pagination">
                        <ul class="pagination">
                            <li class="page-item {{ $currentPage <= 1 ? 'disabled' : '' }}">
                                <a class="page-link" wire:click="previous" tabindex="-1" aria-disabled="true">
                                    <i class="icon-chevron-left"></i>
                                </a>
                            </li>
                            @foreach ($pages as $page)
                                <li class="page-item {{ $currentPage == $page ? 'active' : '' }}">
                                    <a class="page-link" wire:click="setPage({{ $page }}, '{{ $slug_id }}', '{{ json_encode($opt) }}')">{{ $page }}</a>
                                </li>
                            @endforeach
                            <li class="page-item {{ $currentPage >= $totalPages ? 'disabled' : '' }}">
                                <a class="page-link" wire:click="next" tabindex="-1" aria-disabled="true">
                                    <i class="icon-chevron-right"></i>
                                </a>
                            </li>
                        </ul>
                    </nav>
                    <div class="pagination-info">
                        <p class="text-muted">{{ __('frontend::lang.page.show') }} {{ $currentPage * $per_page }}-{{ ($currentPage + 1) * $per_page }} {{ __('frontend::lang.page.of') }} {{ ($currentPage + 1) * $per_page }} {{ __('frontend::lang.page.products') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif
