<?php

namespace Modules\Frontend\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Modules\Contact\app\Http\Controllers\ContactController;
use Modules\Content\app\Http\Controllers\ContentPageController;
use Modules\Content\app\Http\Controllers\ContentsController;
use Modules\Frontend\Livewire\LoginForm;
use Modules\Map\app\Models\CheckInOut;
use Modules\Member\app\Models\Member;
use Modules\Menu\app\Http\Controllers\MenuController;
use Modules\Mwz\app\Http\Controllers\SlugController;

class FrontendController extends FrontendInitController
{
    public function slug(Request $request, $slug_name = '')
    {
        $split_url = $request->segments();
        if (!empty($split_url[0]) && $split_url[0] == app()->getLocale()) {
            unset($split_url[0]);
            $split_url = array_values($split_url);
        }
        $count_split_url = count($split_url);
        if (count($split_url) > 1) {
            if (is_numeric(end($split_url))) {
                end($split_url);
                $key = key($split_url);
                $slug_name = $split_url[$key - 1];
            } else
                $slug_name = end($split_url);
        } else
            $slug_name = reset($split_url) ?? null;
        if (!empty($slug_name)) {
            // check all slug
            do {
                $slug = SlugController::getSlug($split_url[--$count_split_url]);
            } while (empty($slug['slug']) && $count_split_url > 0);

            if (!empty($slug['slug'])) {
                $metadata = [
                    'data_id' => $slug['slug']->data_id,
                    'slug' => $slug['slug']->slug,
                    'meta_auther' => $slug['slug']->meta_auther,
                    'meta_title' => $slug['slug']->meta_title,
                    'meta_keywords' => $slug['slug']->meta_keywords,
                    'meta_description' => $slug['slug']->meta_description,
                    'meta_image' => $slug['slug']->meta_image,
                    'meta_robots' => $slug['slug']->meta_robots,
                ];

                if (!empty($request->get('lang_switch'))) {
                    foreach ($slug['lang_switch'] as $key => $value) {
                        $query = http_build_query($request->all());
                        if (!empty($query))
                            $slug['lang_switch'][$key] = $value . '?' . $query;
                    }
                }

                $request->merge(['slug_uid' => $slug['slug']->uid]);
                $request->merge(['lang_switch' => $slug['lang_switch']]);
                $request->merge(['metadata' => $metadata]);
                $request->merge(['all_slug' => $split_url]);

                return $this->{$slug['slug']->method}($request);
            } else
                return $this->index($request);
        }

        return $this->index($request);
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $data = [
            'page_init' => $this->pageInit($request),
            'member' => Auth::guard('member')->user() ?? [],
        ];
        $redirect = FrontendInitController::check_session($data);
        return $redirect ?? view('frontend::index', $data);
    }

    public function about(Request $request)
    {
        $breadcrumb = [
            MenuController::menu_route(2),
            MenuController::menu_route(3),
        ];
        $data = [
            'page_init' => $this->pageInit($request),
            'breadcrumb' => $breadcrumb,
            'content' => ContentPageController::page('about'),
        ];
        return view('frontend::about', $data);
    }
    public function login(Request $request)
    {
        // ถ้า login แล้ว ให้ redirect ตาม role
        if (Auth::guard('member')->check()) {
            $user = Auth::guard('member')->user();
            return LoginForm::redirectBasedOnRole($user);
        }
        return view('frontend::login');
    }

    public function resetPassword(Request $request, $id)
    {
        $data = [
            'page_init' => $this->pageInit($request),
            'member_id' => $id ?? '',
        ];
        return view('frontend::resetpass', $data);
    }

    /**
     * Update password after reset
     */
    public function updatePassword(Request $request, $id)
    {
        // Validate input
        $request->validate([
            'password' => 'required|string|min:8|confirmed',
        ], [
            'password.required' => 'กรุณากรอกรหัสผ่านใหม่',
            'password.min' => 'รหัสผ่านต้องมีอย่างน้อย 8 ตัวอักษร',
            'password.confirmed' => 'รหัสผ่านและการยืนยันรหัสผ่านไม่ตรงกัน',
        ]);

        // Find member
        $member = Member::find($id);

        if (!$member) {
            return redirect()->route('frontend.login')
                ->with('error', 'ไม่พบข้อมูลสมาชิก');
        }

        // Update password
        $member->password = Hash::make($request->password);
        $member->save();

        // Redirect back to reset password page with success message
        // Modal will show and then redirect to login page
        return redirect()->route('frontend.reset-password', $id)
            ->with('success', 'รีเซ็ตรหัสผ่านสำเร็จ กรุณาเข้าสู่ระบบด้วยรหัสผ่านใหม่');
    }
    public function recorddata(Request $request)
    {
        $data = [
            'page_init' => $this->pageInit($request),
            'member' => Auth::guard('member')->user() ?? [],
        ];
        return view('frontend::recorddata', $data);
    }
    public function recorddatamanager(Request $request)
    {
        $data = [
            'page_init' => $this->pageInit($request),
            'member' => Auth::guard('member')->user(),
            'type' => 'recorddatamanager',
        ];

        $redirect = FrontendInitController::check_session($data);
        return  $redirect ?? view('frontend::recorddatamanager', $data);
    }
    public function member()
    {
        return view('frontend::member');
    }
    public function personalinformation(Request $request)
    {
		$redirect = FrontendInitController::ensureActiveMember();
		if ($redirect instanceof RedirectResponse) {
			return $redirect;
		}
        $data = [
            'page_init' => $this->pageInit($request),
            'member' => Auth::guard('member')->user(),
        ];
        return view('frontend::personalinformation', $data);
    }
    public function requestapproval(Request $request)
    {
		$redirect = FrontendInitController::ensureActiveMember();
		if ($redirect instanceof RedirectResponse) {
			return $redirect;
		}
        $data = [
            'page_init' => $this->pageInit($request),
            'member' => Auth::guard('member')->user(),
        ];
        return view('frontend::requestapproval', $data);
    }
    public function recorddatabu(Request $request)
    {
        $data = [
            'page_init' => $this->pageInit($request),
            'member' => Auth::guard('member')->user(),
        ];
        $redirect = FrontendInitController::check_session($data);
        return $redirect ?? view('frontend::recorddatabu', $data);
    }
    public function approvaldetails(Request $request)
    {
		$redirect = FrontendInitController::ensureActiveMember();
		if ($redirect instanceof RedirectResponse) {
			return $redirect;
		}

        $data = [
            'page_init' => $this->pageInit($request),
            'member' => Auth::guard('member')->user(),
        ];
        return view('frontend::approvaldetails', $data);
    }

    /**
     * Export Transportation Fee application form as PDF.
     */
    public function exportTransportationPdf(Request $request)
    {
		$redirect = FrontendInitController::ensureActiveMember();
		if ($redirect instanceof RedirectResponse) {
			return $redirect;
		}

        $rows = [];
        $member = Auth::guard('member')->user();
        // ->whereBetween('created_at', [$request->get('start_date'), $request->get('end_date')]
        $list = CheckInOut::where([['member_id', $member->id]]);
        if (!empty($request->get('start_date')) && !empty($request->get('end_date'))) {
            $list = $list->whereBetween('created_at', [$request->get('start_date'), $request->get('end_date')]);
        }
        $list = $list->orderBy('code_req', 'desc')->get();
        if (!empty($list)) {
            foreach ($list as $item) {
                $rows[] = [
                    'date' => $item->created_at->format('d/m/Y'),
                    'time' => $item->time->format('H:i'),
                    'from_company' => $item->current_place,
                    'to_company' => $item->target_place,
                    'purpose' => $item->reason,
                    'distance_km' => $item->distance_km,
                    'oil_cost' => $item->oil_price ?? 0,
                    'rate' => $item->rate ?? 0,
                    'amount' => $item->oil_price ?? 0,
                ];
                $status_all[] = $item->status;
            }
        }
        // ถ้าสถานะเป็น 4 ให้แสดงชื่อคนอนุมัติ และวันที่อนุมัติ
        $approve  = null;
        $approved_date = null;

        // ตรวจสอบว่า $status_all ทุกค่ามีค่าเป็น 4 หรือไม่
        $all_status_4 = !empty($status_all) && count($status_all) > 0 && collect($status_all)->every(fn($status) => $status == 4);
        if (!empty($all_status_4)) {
            ///manager
            $approve = [
                'manager' => [
                    'name' => $member->parent->parent->name ?? '',
                    'date' => date('d/m/Y'),
                ],
                'bu' => [
                    'name' => $member->parent->name ?? '',
                    'date' => date('d/m/Y'),
                ],
            ];
        }

        $data = [
            'employee' => [
                'code' => $member->code,
                'name' => $member->name,
                'department' => $member->department,
                'position' => $member->position,
                'date_fo_print' => date('d/m/Y'),
                'approve' => $approve,
            ],

            'rows' => $rows,
        ];
        $pdf = Pdf::loadView('frontend::pdf.transportation', $data)
            ->setPaper('A4', 'portrait');

        return $pdf->stream('transportation-fee.pdf');
    }

    public function contact(Request $request)
    {
        $breadcrumb = [
            MenuController::menu_route(2),
            MenuController::menu_route(6),
        ];
        $contact = ContactController::contact();
        $data = [
            'page_init' => $this->pageInit($request),
            'breadcrumb' => $breadcrumb,
            'contact' => $contact,
            'title' => ContactController::set_title_contact($contact['name'] ?? ''),
        ];
        return view('frontend::contact', $data);
    }


    public function content(Request $request)
    // public function customerStory()
    {
        $breadcrumb = [
            MenuController::menu_route(2),
            MenuController::menu_route(5),
        ];
        $data = [
            'page_init' => $this->pageInit($request),
            'breadcrumb' => $breadcrumb,
        ];
        return view('frontend::customer-story', $data);
    }

    // public function customerStoryDetail()
    public function news_content(Request $request)
    {
        $detail = ContentsController::get_list('news', ['id' => $request->get('metadata')['data_id'] ?? [], 'full' => true])['list'][0] ?? [];
        $breadcrumb = [
            MenuController::menu_route(2),
            MenuController::menu_route(5),
            $detail
        ];
        $data = [
            'page_init' => $this->pageInit($request),
            'id' => $request->get('metadata')['data_id'] ?? [],
            'detail' => $detail,
            'breadcrumb' => $breadcrumb,
        ];
        return view('frontend::customer-story-detail', $data);
    }

    // new 
    public function check(Request $request)
    {
        $data = [
            'page_init' => $this->pageInit($request),
            'member' => Auth::guard('member')->user(),
        ];

        $redirect = FrontendInitController::check_session($data);
        return $redirect ?? view('frontend::check', $data);
    }

    public function checkout_map(Request $request)
    {
        $data = [
            'page_init' => $this->pageInit($request),
            'member' => Auth::guard('member')->user(),
        ];

        $redirect = FrontendInitController::check_session($data);
        return $redirect ?? $this->check($request);
    }
}
