<?php

namespace Modules\Frontend\app\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ApprovalNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $subject, $data, $setting, $contact, $config;

    /**
     * Create a new message instance.
     */
    public function __construct($subject, $data)
    {
        $this->subject = $subject;
        $this->data = $data;
        $this->setting = setting();
        $this->contact = contact();
        $this->config = config_email();
    }

    /**
     * Build the message.
     */
    public function build(): self
    {
        return $this->subject($this->subject)
            ->view('mail.simple', [
                'subject' => $this->subject,
                'data' => $this->data,
                'setting' => $this->setting,
                'contact' => $this->contact,
                'config' => $this->config,
            ]);
    }
}

