<?php

namespace Modules\Frontend\Traits;

use Illuminate\Support\Facades\Cookie;

trait WithPaginationLogic
{
	/**
	 * Function : set page
	 * Dev : Wan
	 * Update Date : 09 December 2024
	 */
	public function setPage($page, $slug_id = null, $opt = '')
	{
		$this->cur_page = $page;
		$json = json_decode($opt, true);
		if (!is_array($json)) {
			$json = [];
		}
		$json['cur_page'] = $page;
		if(!empty($slug_id) and !empty($json)) Cookie::queue(Cookie::make($slug_id, json_encode($json), 30 * 24 * 60));
	}

	/**
	 * Function : previous page
	 * Dev : Wan
	 * Update Date : 09 December 2024
	 */
	public function previous()
	{
		$this->cur_page--;
		$this->SetCurrentPage($this->cur_page);
	}

	/**
	 * Function : next page
	 * Dev : Wan
	 * Update Date : 09 December 2024
	 */
	public function next()
	{
		if ($this->page_total > $this->cur_page) {
			$this->cur_page++;
			$this->SetCurrentPage($this->cur_page);
		} else {
			$this->SetCurrentPage($this->page_total);
		}
	}

	/**
	 * Function : set current page
	 * Dev : Wan
	 * Update Date : 09 December 2024
	 */
	public function SetCurrentPage($currentPage)
	{

		\Illuminate\Pagination\Paginator::currentPageResolver(function () use ($currentPage) {
			return $currentPage;
		});
	}
}

