<?php

namespace Modules\Frontend\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;

class LogoutButton extends Component
{
    /**
     * Logout function
     */
    public function logout()
    {
        Auth::logout();
        
        session()->invalidate();
        session()->regenerateToken();
        
        return redirect()->route('frontend.login')->with('message', 'ออกจากระบบเรียบร้อยแล้ว');
    }

    public function render()
    {
        return view('frontend::livewire.logout-button');
    }
}

