<?php

namespace Modules\Frontend\Livewire;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Modules\Map\app\Models\CheckInOut;
use Modules\Member\app\Models\Member;

class ListPersonal extends Component
{
    public $member,$list,$member_id;
    public $start_date,$end_date;
    public $selected_rows = [];

    public function render()
    {
        $this->member_id = Auth::guard('member')->user()->id;

        $this->list = CheckInOut::where('member_id', $this->member_id);
        if(!empty($this->start_date) && !empty($this->end_date)){
            $this->list->whereBetween('created_at', [$this->start_date, $this->end_date]);
        }
        $this->list = $this->list->get();
        $this->member = Member::find($this->member_id);
        return view('frontend::livewire.list-personal');
    }

    public function filterHistory()
    {
        $this->validate([
            'start_date' => 'required|date',
            'end_date' => 'required|date',
        ]);
        $this->start_date = Carbon::parse($this->start_date)->format('Y-m-d H:i');
        $this->end_date = Carbon::parse($this->end_date)->format('Y-m-d H:i');
    }


    public function sendReport()
    {
        if (empty($this->selected_rows)) {
            $this->dispatch('alert', [
                'type' => 'warning',
                'title' => 'กรุณาเลือกข้อมูลที่จะส่งรายงาน',
            ]);
            return;
        }

        $this->validate([
            'selected_rows' => 'required|array',
        ]);
        
        $selectedRows = $this->selected_rows;
        // TODO: ส่งข้อมูลรายงานไปยังระบบ

        $this->dispatch('alert', [
            'type' => 'success',
            'title' => 'ส่งรายงานการเดินทางเรียบร้อยแล้ว',
        ]);
        // เงื่อนไข: ให้มี member_id และ date 4 หลัก
        // code_req เดิม: REQ-memberid-YYYYMMDD-#### 
        // ใหม่: code_req = REQ-memberid-YYYYMMDD-HHMMSS-####
        $today = date('Y-m-d');
        $now = now();
        $currentTime = $now->format('His'); // HHMMSS

        $lastRequest = CheckInOut::where('member_id', $this->member_id)
            ->whereDate('created_at', $today)
            ->whereNotNull('code_req')
            // หาอันล่าสุดของวันนี้ที่มี HHMMSS เดียวกัน
            ->where('code_req', 'like', sprintf('REQ-%s-%s-%s-%%%%', $this->member_id, date('Ymd'), $currentTime))
            ->orderByDesc('created_at')
            ->first();

        $nextSeq = 1;
        if ($lastRequest && preg_match('/REQ-\d+-\d+-\d+-([0-9]{4})/', $lastRequest->code_req, $matches)) {
            $nextSeq = intval($matches[1]) + 1;
        }

        $code_req = sprintf(
            'REQ-%s-%s-%s-%04d',
            $this->member_id,
            date('Ymd'),
            $currentTime,
            $nextSeq
        );
        // update status of selected rows
        $status = $this->member->lavel_id === 2 ? 3 : 2;
        CheckInOut::whereIn('id', $selectedRows)->update([
            'status' => $status,
            'code_req' => $code_req,
            'submission_date' => $now
        ]);
        // Clear selected rows after sending
        $this->selected_rows = [];
    }   
}
