<?php

namespace Modules\Frontend\Livewire\ListData;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use Modules\Frontend\app\Http\Controllers\FrontendInitController;
use Modules\Map\app\Models\CheckInOut;
use Modules\Member\app\Http\Controllers\MemberController;
use Modules\Member\app\Models\Member;

class RequestList extends Component
{
    public $request_approval , $page ,$page_approval;
    public function render()
    {
        $member = Auth::guard('member')->user();

        // แยกหา member ที่เราเป็น approve_by_first_id
        $member_first = Member::where('approve_by_first_id', $member->id)->get();
        $member_first_ids = $member_first->pluck('id');

        // แยกหา member ที่เราเป็น approve_by_second_id
        $member_second = Member::where('approve_by_second_id', $member->id)->get();
        $member_second_ids = $member_second->pluck('id');

        // รวม member_id ทั้ง 2 แบบและตัดซ้ำออก
        $all_member_ids = $member_first_ids->merge($member_second_ids)->unique();

        // คิวรี่หาข้อมูล approval ที่เกี่ยวข้อง
        $this->request_approval = MemberController::CountItems($member->id);

        $this->page_approval = !empty(FrontendInitController::CheckPageMenu()) ? true : false;

        // $this->dispatch('request_count', $this->request_approval->count());

        return view('frontend::livewire.list-data.request-list');
    }
}
